/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.predicates;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.gobblin.data.management.copy.hive.HiveCopyEntityHelper;
import org.apache.gobblin.data.management.copy.hive.HivePartitionFileSet;
import org.apache.gobblin.util.PathUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistrationTimeSkipPredicate
implements Predicate<HivePartitionFileSet> {
    private static final Logger log = LoggerFactory.getLogger(RegistrationTimeSkipPredicate.class);
    private final HiveCopyEntityHelper helper;

    public boolean apply(@Nullable HivePartitionFileSet input) {
        if (input == null) {
            return true;
        }
        if (input.getExistingTargetPartition() == null) {
            throw new RuntimeException("Existing target partition has not been computed! This is an error in the code.");
        }
        if (PathUtils.isGlob((Path)input.getPartition().getDataLocation())) {
            log.error(String.format("%s cannot be applied to globbed location %s. Will not skip.", this.getClass().getSimpleName(), input.getPartition().getDataLocation()));
            return false;
        }
        if (!input.getExistingTargetPartition().isPresent()) {
            return false;
        }
        if (!((Partition)input.getExistingTargetPartition().get()).getParameters().containsKey("registrationGenerationTimeMillis")) {
            return false;
        }
        try {
            long oldRegistrationTime = Long.parseLong((String)((Partition)input.getExistingTargetPartition().get()).getParameters().get("registrationGenerationTimeMillis"));
            Optional<FileStatus> sourceFileStatus = this.helper.getConfiguration().getCopyContext().getFileStatus(this.helper.getDataset().getFs(), input.getPartition().getDataLocation());
            if (!sourceFileStatus.isPresent()) {
                throw new RuntimeException(String.format("Source path %s does not exist!", input.getPartition().getDataLocation()));
            }
            return oldRegistrationTime > ((FileStatus)sourceFileStatus.get()).getModificationTime();
        }
        catch (NumberFormatException nfe) {
            log.warn(String.format("Cannot parse %s in partition %s. Will not skip.", "registrationGenerationTimeMillis", input.getPartition().getCompleteName()));
            return false;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public RegistrationTimeSkipPredicate(HiveCopyEntityHelper helper) {
        this.helper = helper;
    }
}

