/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.iceberg;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.gobblin.data.management.copy.iceberg.IcebergSnapshotInfo;
import org.apache.gobblin.dataset.DatasetDescriptor;
import org.apache.hadoop.fs.FileSystem;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergTable {
    private static final Logger log = LoggerFactory.getLogger(IcebergTable.class);
    private final TableIdentifier tableId;
    private final TableOperations tableOps;
    private final String catalogUri;

    public IcebergSnapshotInfo getCurrentSnapshotInfo() throws IOException {
        TableMetadata current = this.accessTableMetadata();
        return this.createSnapshotInfo(current.currentSnapshot(), Optional.of(current.metadataFileLocation()));
    }

    public IcebergSnapshotInfo getCurrentSnapshotInfoOverviewOnly() throws IOException {
        TableMetadata current = this.accessTableMetadata();
        return this.createSnapshotInfo(current.currentSnapshot(), Optional.of(current.metadataFileLocation()), true);
    }

    public Iterator<IcebergSnapshotInfo> getAllSnapshotInfosIterator() throws IOException {
        TableMetadata current = this.accessTableMetadata();
        long currentSnapshotId = current.currentSnapshot().snapshotId();
        List snapshots = current.snapshots();
        return Iterators.transform(snapshots.iterator(), snapshot -> {
            try {
                return this.createSnapshotInfo((Snapshot)snapshot, currentSnapshotId == snapshot.snapshotId() ? Optional.of(current.metadataFileLocation()) : Optional.empty());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public Iterator<IcebergSnapshotInfo> getIncrementalSnapshotInfosIterator() throws IOException {
        HashSet knownFilePaths = Sets.newHashSet();
        return Iterators.filter((Iterator)Iterators.transform(this.getAllSnapshotInfosIterator(), snapshotInfo -> {
            log.info("~{}~ before snapshot '{}' - '{}' total known iceberg paths", new Object[]{this.tableId, snapshotInfo.getSnapshotId(), knownFilePaths.size()});
            if (!knownFilePaths.add(snapshotInfo.getManifestListPath())) {
                return snapshotInfo.toBuilder().manifestListPath(null).build();
            }
            ArrayList novelManifestInfos = Lists.newArrayList();
            for (IcebergSnapshotInfo.ManifestFileInfo mfi : snapshotInfo.getManifestFiles()) {
                if (!knownFilePaths.add(mfi.getManifestFilePath())) continue;
                List<String> novelListedPaths = mfi.getListedFilePaths().stream().filter(fpath -> true == knownFilePaths.add(fpath)).collect(Collectors.toList());
                if (novelListedPaths.size() == mfi.getListedFilePaths().size()) {
                    novelManifestInfos.add(mfi);
                    continue;
                }
                novelManifestInfos.add(new IcebergSnapshotInfo.ManifestFileInfo(mfi.getManifestFilePath(), novelListedPaths));
            }
            if (novelManifestInfos.size() == snapshotInfo.getManifestFiles().size()) {
                return snapshotInfo;
            }
            return snapshotInfo.toBuilder().manifestFiles(novelManifestInfos).build();
        }), snapshotInfo -> snapshotInfo.getManifestListPath() != null);
    }

    protected TableMetadata accessTableMetadata() throws TableNotFoundException {
        TableMetadata current = this.tableOps.current();
        return Optional.ofNullable(current).orElseThrow(() -> new TableNotFoundException(this.tableId));
    }

    protected IcebergSnapshotInfo createSnapshotInfo(Snapshot snapshot, Optional<String> metadataFileLocation) throws IOException {
        return this.createSnapshotInfo(snapshot, metadataFileLocation, false);
    }

    protected IcebergSnapshotInfo createSnapshotInfo(Snapshot snapshot, Optional<String> metadataFileLocation, boolean skipManifestFileInfo) throws IOException {
        return new IcebergSnapshotInfo(snapshot.snapshotId(), Instant.ofEpochMilli(snapshot.timestampMillis()), metadataFileLocation, snapshot.manifestListLocation(), (List<IcebergSnapshotInfo.ManifestFileInfo>)(skipManifestFileInfo ? Lists.newArrayList() : IcebergTable.calcAllManifestFileInfos(snapshot.allManifests(), this.tableOps.io())));
    }

    protected static List<IcebergSnapshotInfo.ManifestFileInfo> calcAllManifestFileInfos(List<ManifestFile> manifests, FileIO io) throws IOException {
        ArrayList result = Lists.newArrayList();
        for (ManifestFile manifest : manifests) {
            result.add(IcebergTable.calcManifestFileInfo(manifest, io));
        }
        return result;
    }

    protected static IcebergSnapshotInfo.ManifestFileInfo calcManifestFileInfo(ManifestFile manifest, FileIO io) throws IOException {
        return new IcebergSnapshotInfo.ManifestFileInfo(manifest.path(), IcebergTable.discoverDataFilePaths(manifest, io));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<String> discoverDataFilePaths(ManifestFile manifest, FileIO io) throws IOException {
        try (CloseableIterable manifestPathsIterable = ManifestFiles.readPaths((ManifestFile)manifest, (FileIO)io);){
            ArrayList arrayList = Lists.newArrayList((Iterable)manifestPathsIterable);
            return arrayList;
        }
    }

    protected DatasetDescriptor getDatasetDescriptor(FileSystem fs) {
        DatasetDescriptor descriptor = new DatasetDescriptor("iceberg", URI.create(this.catalogUri), this.tableId.name());
        descriptor.addMetadata("fsUri", fs.getUri().toString());
        return descriptor;
    }

    protected void registerIcebergTable(TableMetadata srcMetadata, TableMetadata dstMetadata) {
        if (dstMetadata != null) {
            this.tableOps.commit(dstMetadata, srcMetadata.replaceProperties(dstMetadata.properties()));
        }
    }

    public IcebergTable(TableIdentifier tableId, TableOperations tableOps, String catalogUri) {
        this.tableId = tableId;
        this.tableOps = tableOps;
        this.catalogUri = catalogUri;
    }

    public TableIdentifier getTableId() {
        return this.tableId;
    }

    public static class TableNotFoundException
    extends IOException {
        private final TableIdentifier tableId;

        public TableNotFoundException(TableIdentifier tableId) {
            super("Not found: '" + tableId + "'");
            this.tableId = tableId;
        }

        public TableIdentifier getTableId() {
            return this.tableId;
        }
    }
}

