/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.iceberg;

import com.google.common.collect.Lists;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class IcebergSnapshotInfo {
    private final Long snapshotId;
    private final Instant timestamp;
    private final Optional<String> metadataPath;
    private final String manifestListPath;
    private final List<ManifestFileInfo> manifestFiles;

    public List<String> getManifestFilePaths() {
        return this.manifestFiles.stream().map(ManifestFileInfo::getManifestFilePath).collect(Collectors.toList());
    }

    public List<String> getAllDataFilePaths() {
        return this.manifestFiles.stream().map(ManifestFileInfo::getListedFilePaths).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<String> getSnapshotApexPaths() {
        List result = this.metadataPath.map(xva$0 -> Lists.newArrayList((Object[])new String[]{xva$0})).orElse(Lists.newArrayList());
        result.add(this.manifestListPath);
        return result;
    }

    public List<String> getAllPaths() {
        List<String> result = this.getSnapshotApexPaths();
        result.addAll(this.getManifestFilePaths());
        result.addAll(this.getAllDataFilePaths());
        return result;
    }

    IcebergSnapshotInfo(Long snapshotId, Instant timestamp, Optional<String> metadataPath, String manifestListPath, List<ManifestFileInfo> manifestFiles) {
        this.snapshotId = snapshotId;
        this.timestamp = timestamp;
        this.metadataPath = metadataPath;
        this.manifestListPath = manifestListPath;
        this.manifestFiles = manifestFiles;
    }

    public static IcebergSnapshotInfoBuilder builder() {
        return new IcebergSnapshotInfoBuilder();
    }

    public IcebergSnapshotInfoBuilder toBuilder() {
        return new IcebergSnapshotInfoBuilder().snapshotId(this.snapshotId).timestamp(this.timestamp).metadataPath(this.metadataPath).manifestListPath(this.manifestListPath).manifestFiles(this.manifestFiles);
    }

    public Long getSnapshotId() {
        return this.snapshotId;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public Optional<String> getMetadataPath() {
        return this.metadataPath;
    }

    public String getManifestListPath() {
        return this.manifestListPath;
    }

    public List<ManifestFileInfo> getManifestFiles() {
        return this.manifestFiles;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IcebergSnapshotInfo)) {
            return false;
        }
        IcebergSnapshotInfo other = (IcebergSnapshotInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$snapshotId = this.getSnapshotId();
        Long other$snapshotId = other.getSnapshotId();
        if (this$snapshotId == null ? other$snapshotId != null : !((Object)this$snapshotId).equals(other$snapshotId)) {
            return false;
        }
        Instant this$timestamp = this.getTimestamp();
        Instant other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Optional<String> this$metadataPath = this.getMetadataPath();
        Optional<String> other$metadataPath = other.getMetadataPath();
        if (this$metadataPath == null ? other$metadataPath != null : !((Object)this$metadataPath).equals(other$metadataPath)) {
            return false;
        }
        String this$manifestListPath = this.getManifestListPath();
        String other$manifestListPath = other.getManifestListPath();
        if (this$manifestListPath == null ? other$manifestListPath != null : !this$manifestListPath.equals(other$manifestListPath)) {
            return false;
        }
        List<ManifestFileInfo> this$manifestFiles = this.getManifestFiles();
        List<ManifestFileInfo> other$manifestFiles = other.getManifestFiles();
        return !(this$manifestFiles == null ? other$manifestFiles != null : !((Object)this$manifestFiles).equals(other$manifestFiles));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IcebergSnapshotInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $snapshotId = this.getSnapshotId();
        result = result * 59 + ($snapshotId == null ? 43 : ((Object)$snapshotId).hashCode());
        Instant $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Optional<String> $metadataPath = this.getMetadataPath();
        result = result * 59 + ($metadataPath == null ? 43 : ((Object)$metadataPath).hashCode());
        String $manifestListPath = this.getManifestListPath();
        result = result * 59 + ($manifestListPath == null ? 43 : $manifestListPath.hashCode());
        List<ManifestFileInfo> $manifestFiles = this.getManifestFiles();
        result = result * 59 + ($manifestFiles == null ? 43 : ((Object)$manifestFiles).hashCode());
        return result;
    }

    public String toString() {
        return "IcebergSnapshotInfo(snapshotId=" + this.getSnapshotId() + ", timestamp=" + this.getTimestamp() + ", metadataPath=" + this.getMetadataPath() + ", manifestListPath=" + this.getManifestListPath() + ", manifestFiles=" + this.getManifestFiles() + ")";
    }

    public static class IcebergSnapshotInfoBuilder {
        private Long snapshotId;
        private Instant timestamp;
        private Optional<String> metadataPath;
        private String manifestListPath;
        private List<ManifestFileInfo> manifestFiles;

        IcebergSnapshotInfoBuilder() {
        }

        public IcebergSnapshotInfoBuilder snapshotId(Long snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public IcebergSnapshotInfoBuilder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public IcebergSnapshotInfoBuilder metadataPath(Optional<String> metadataPath) {
            this.metadataPath = metadataPath;
            return this;
        }

        public IcebergSnapshotInfoBuilder manifestListPath(String manifestListPath) {
            this.manifestListPath = manifestListPath;
            return this;
        }

        public IcebergSnapshotInfoBuilder manifestFiles(List<ManifestFileInfo> manifestFiles) {
            this.manifestFiles = manifestFiles;
            return this;
        }

        public IcebergSnapshotInfo build() {
            return new IcebergSnapshotInfo(this.snapshotId, this.timestamp, this.metadataPath, this.manifestListPath, this.manifestFiles);
        }

        public String toString() {
            return "IcebergSnapshotInfo.IcebergSnapshotInfoBuilder(snapshotId=" + this.snapshotId + ", timestamp=" + this.timestamp + ", metadataPath=" + this.metadataPath + ", manifestListPath=" + this.manifestListPath + ", manifestFiles=" + this.manifestFiles + ")";
        }
    }

    public static class ManifestFileInfo {
        private final String manifestFilePath;
        private final List<String> listedFilePaths;

        public ManifestFileInfo(String manifestFilePath, List<String> listedFilePaths) {
            this.manifestFilePath = manifestFilePath;
            this.listedFilePaths = listedFilePaths;
        }

        public String getManifestFilePath() {
            return this.manifestFilePath;
        }

        public List<String> getListedFilePaths() {
            return this.listedFilePaths;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ManifestFileInfo)) {
                return false;
            }
            ManifestFileInfo other = (ManifestFileInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$manifestFilePath = this.getManifestFilePath();
            String other$manifestFilePath = other.getManifestFilePath();
            if (this$manifestFilePath == null ? other$manifestFilePath != null : !this$manifestFilePath.equals(other$manifestFilePath)) {
                return false;
            }
            List<String> this$listedFilePaths = this.getListedFilePaths();
            List<String> other$listedFilePaths = other.getListedFilePaths();
            return !(this$listedFilePaths == null ? other$listedFilePaths != null : !((Object)this$listedFilePaths).equals(other$listedFilePaths));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ManifestFileInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $manifestFilePath = this.getManifestFilePath();
            result = result * 59 + ($manifestFilePath == null ? 43 : $manifestFilePath.hashCode());
            List<String> $listedFilePaths = this.getListedFilePaths();
            result = result * 59 + ($listedFilePaths == null ? 43 : ((Object)$listedFilePaths).hashCode());
            return result;
        }

        public String toString() {
            return "IcebergSnapshotInfo.ManifestFileInfo(manifestFilePath=" + this.getManifestFilePath() + ", listedFilePaths=" + this.getListedFilePaths() + ")";
        }
    }
}

