/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.iceberg;

import java.io.IOException;
import java.util.Properties;
import org.apache.gobblin.commit.CommitStep;
import org.apache.gobblin.data.management.copy.iceberg.IcebergDatasetFinder;
import org.apache.gobblin.data.management.copy.iceberg.IcebergTable;
import org.apache.iceberg.TableMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergRegisterStep
implements CommitStep {
    private static final Logger log = LoggerFactory.getLogger(IcebergRegisterStep.class);
    private final String dbName;
    private final String tblName;
    private final Properties properties;

    public boolean isCompleted() throws IOException {
        return false;
    }

    public void execute() throws IOException {
        IcebergTable srcIcebergTable = IcebergDatasetFinder.createIcebergCatalog(this.properties, IcebergDatasetFinder.CatalogLocation.SOURCE).openTable(this.dbName, this.tblName);
        IcebergTable destIcebergTable = IcebergDatasetFinder.createIcebergCatalog(this.properties, IcebergDatasetFinder.CatalogLocation.DESTINATION).openTable(this.dbName, this.tblName);
        TableMetadata destinationMetadata = null;
        try {
            destinationMetadata = destIcebergTable.accessTableMetadata();
        }
        catch (IcebergTable.TableNotFoundException tnfe) {
            log.warn("Destination TableMetadata doesn't exist because: ", (Throwable)tnfe);
        }
        destIcebergTable.registerIcebergTable(srcIcebergTable.accessTableMetadata(), destinationMetadata);
    }

    public String toString() {
        return String.format("Registering Iceberg Table: {%s}.{%s} ", this.dbName, this.tblName);
    }

    public IcebergRegisterStep(String dbName, String tblName, Properties properties) {
        this.dbName = dbName;
        this.tblName = tblName;
        this.properties = properties;
    }
}

