/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.iceberg;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.config.ConfigBuilder;
import org.apache.gobblin.data.management.copy.iceberg.IcebergCatalog;
import org.apache.gobblin.data.management.copy.iceberg.IcebergCatalogFactory;
import org.apache.gobblin.data.management.copy.iceberg.IcebergDataset;
import org.apache.gobblin.data.management.copy.iceberg.IcebergTable;
import org.apache.gobblin.dataset.IterableDatasetFinder;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergDatasetFinder
implements IterableDatasetFinder<IcebergDataset> {
    private static final Logger log = LoggerFactory.getLogger(IcebergDatasetFinder.class);
    public static final String ICEBERG_DATASET_PREFIX = "iceberg.dataset";
    public static final String DEFAULT_ICEBERG_CATALOG_CLASS = "org.apache.gobblin.data.management.copy.iceberg.IcebergHiveCatalog";
    public static final String ICEBERG_CATALOG_KEY = "catalog";
    public static final String ICEBERG_CATALOG_CLASS_KEY = "class";
    public static final String ICEBERG_DB_NAME = "iceberg.dataset.database.name";
    public static final String ICEBERG_TABLE_NAME = "iceberg.dataset.table.name";
    protected final FileSystem sourceFs;
    private final Properties properties;

    public List<IcebergDataset> findDatasets() throws IOException {
        ArrayList<IcebergDataset> matchingDatasets = new ArrayList<IcebergDataset>();
        if (StringUtils.isBlank((String)this.properties.getProperty(ICEBERG_DB_NAME)) || StringUtils.isBlank((String)this.properties.getProperty(ICEBERG_TABLE_NAME))) {
            throw new IllegalArgumentException(String.format("Iceberg database name: {%s} or Iceberg table name: {%s} is missing", ICEBERG_DB_NAME, ICEBERG_TABLE_NAME));
        }
        String dbName = this.properties.getProperty(ICEBERG_DB_NAME);
        String tblName = this.properties.getProperty(ICEBERG_TABLE_NAME);
        IcebergCatalog sourceIcebergCatalog = IcebergDatasetFinder.createIcebergCatalog(this.properties, CatalogLocation.SOURCE);
        IcebergCatalog destinationIcebergCatalog = IcebergDatasetFinder.createIcebergCatalog(this.properties, CatalogLocation.DESTINATION);
        matchingDatasets.add(this.createIcebergDataset(dbName, tblName, sourceIcebergCatalog, destinationIcebergCatalog, this.properties, this.sourceFs));
        log.info("Found {} matching datasets: {} for the database name: {} and table name: {}", new Object[]{matchingDatasets.size(), matchingDatasets, dbName, tblName});
        return matchingDatasets;
    }

    public Path commonDatasetRoot() {
        return new Path("/");
    }

    public Iterator<IcebergDataset> getDatasetsIterator() throws IOException {
        return this.findDatasets().iterator();
    }

    protected IcebergDataset createIcebergDataset(String dbName, String tblName, IcebergCatalog sourceIcebergCatalog, IcebergCatalog destinationIcebergCatalog, Properties properties, FileSystem fs) throws IOException {
        IcebergTable srcIcebergTable = sourceIcebergCatalog.openTable(dbName, tblName);
        Preconditions.checkArgument((boolean)sourceIcebergCatalog.tableAlreadyExists(srcIcebergTable), (Object)String.format("Missing Source Iceberg Table: {%s}.{%s}", dbName, tblName));
        IcebergTable destIcebergTable = destinationIcebergCatalog.openTable(dbName, tblName);
        Preconditions.checkArgument((boolean)destinationIcebergCatalog.tableAlreadyExists(destIcebergTable), (Object)String.format("Missing Destination Iceberg Table: {%s}.{%s}", dbName, tblName));
        return new IcebergDataset(dbName, tblName, srcIcebergTable, destIcebergTable, properties, fs);
    }

    protected static IcebergCatalog createIcebergCatalog(Properties properties, CatalogLocation location) throws IOException {
        String prefix = location.getConfigPrefix();
        Map<String, String> catalogProperties = IcebergDatasetFinder.buildMapFromPrefixChildren(properties, prefix);
        Configuration configuration = HadoopUtils.getConfFromProperties((Properties)properties);
        String icebergCatalogClassName = catalogProperties.getOrDefault(ICEBERG_CATALOG_CLASS_KEY, DEFAULT_ICEBERG_CATALOG_CLASS);
        return IcebergCatalogFactory.create(icebergCatalogClassName, catalogProperties, configuration);
    }

    protected static Map<String, String> buildMapFromPrefixChildren(Properties properties, String configPrefix) {
        HashMap<String, String> catalogProperties = new HashMap<String, String>();
        Config config = ConfigBuilder.create().loadProps(properties, configPrefix).build();
        for (Map.Entry entry : config.entrySet()) {
            catalogProperties.put((String)entry.getKey(), ((ConfigValue)entry.getValue()).unwrapped().toString());
        }
        String catalogUri = config.getString("uri");
        Preconditions.checkNotNull((Object)catalogUri, (String)"Provide: {%s} as Catalog Table Service URI is required", (Object)(configPrefix + "." + "uri"));
        return catalogProperties;
    }

    public IcebergDatasetFinder(FileSystem sourceFs, Properties properties) {
        this.sourceFs = sourceFs;
        this.properties = properties;
    }

    public static enum CatalogLocation {
        SOURCE,
        DESTINATION;


        public String getConfigPrefix() {
            return "iceberg.dataset." + this.toString().toLowerCase() + "." + IcebergDatasetFinder.ICEBERG_CATALOG_KEY + ".";
        }
    }
}

