/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.iceberg;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.gobblin.data.management.copy.CopyConfiguration;
import org.apache.gobblin.data.management.copy.CopyEntity;
import org.apache.gobblin.data.management.copy.CopyableFile;
import org.apache.gobblin.data.management.copy.OwnerAndPermission;
import org.apache.gobblin.data.management.copy.entities.PostPublishStep;
import org.apache.gobblin.data.management.copy.iceberg.IcebergRegisterStep;
import org.apache.gobblin.data.management.copy.iceberg.IcebergSnapshotInfo;
import org.apache.gobblin.data.management.copy.iceberg.IcebergTable;
import org.apache.gobblin.data.management.copy.iceberg.IcebergTableFileSet;
import org.apache.gobblin.data.management.copy.prioritization.PrioritizedCopyableDataset;
import org.apache.gobblin.data.management.partition.FileSet;
import org.apache.gobblin.dataset.DatasetDescriptor;
import org.apache.gobblin.dataset.Descriptor;
import org.apache.gobblin.util.PathUtils;
import org.apache.gobblin.util.function.CheckedExceptionFunction;
import org.apache.gobblin.util.measurement.GrowthMilestoneTracker;
import org.apache.gobblin.util.request_allocation.PushDownRequestor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergDataset
implements PrioritizedCopyableDataset {
    private static final Logger log = LoggerFactory.getLogger(IcebergDataset.class);
    private final String dbName;
    private final String inputTableName;
    private final IcebergTable srcIcebergTable;
    private final IcebergTable destIcebergTable;
    protected final Properties properties;
    protected final FileSystem sourceFs;
    private final boolean shouldTolerateMissingSourceFiles = true;
    public static final String DESTINATION_DATABASE_KEY = "iceberg.dataset.destination.database";

    public IcebergDataset(String db, String table, IcebergTable srcIcebergTable, IcebergTable destIcebergTable, Properties properties, FileSystem sourceFs) {
        this.dbName = db;
        this.inputTableName = table;
        this.srcIcebergTable = srcIcebergTable;
        this.destIcebergTable = destIcebergTable;
        this.properties = properties;
        this.sourceFs = sourceFs;
    }

    public String datasetURN() {
        return this.getFileSetId();
    }

    @Override
    public Iterator<FileSet<CopyEntity>> getFileSetIterator(FileSystem targetFs, CopyConfiguration configuration) {
        return this.createFileSets(targetFs, configuration);
    }

    @Override
    public Iterator<FileSet<CopyEntity>> getFileSetIterator(FileSystem targetFs, CopyConfiguration configuration, Comparator<FileSet<CopyEntity>> prioritizer, PushDownRequestor<FileSet<CopyEntity>> requestor) {
        return this.createFileSets(targetFs, configuration);
    }

    protected String getFileSetId() {
        return this.dbName + "." + this.inputTableName;
    }

    protected Iterator<FileSet<CopyEntity>> createFileSets(FileSystem targetFs, CopyConfiguration configuration) {
        IcebergTableFileSet fileSet = new IcebergTableFileSet(this.getInputTableName(), this, targetFs, configuration);
        return Iterators.singletonIterator((Object)fileSet);
    }

    @VisibleForTesting
    Collection<CopyEntity> generateCopyEntities(FileSystem targetFs, CopyConfiguration copyConfig) throws IOException {
        String fileSet = this.getFileSetId();
        ArrayList copyEntities = Lists.newArrayList();
        Map<Path, FileStatus> pathToFileStatus = this.getFilePathsToFileStatus(targetFs, copyConfig);
        log.info("~{}.{}~ found {} candidate source paths", new Object[]{this.dbName, this.inputTableName, pathToFileStatus.size()});
        Configuration defaultHadoopConfiguration = new Configuration();
        for (Map.Entry<Path, FileStatus> entry : pathToFileStatus.entrySet()) {
            Path srcPath = entry.getKey();
            FileStatus srcFileStatus = entry.getValue();
            FileSystem actualSourceFs = this.getSourceFileSystemFromFileStatus(srcFileStatus, defaultHadoopConfiguration);
            Path greatestAncestorPath = PathUtils.getRootPathChild((Path)srcPath);
            List<OwnerAndPermission> ancestorOwnerAndPermissionList = CopyableFile.resolveReplicatedOwnerAndPermissionsRecursively(actualSourceFs, srcPath.getParent(), greatestAncestorPath, copyConfig);
            CopyableFile fileEntity = CopyableFile.fromOriginAndDestination(actualSourceFs, srcFileStatus, targetFs.makeQualified(srcPath), copyConfig).fileSet(fileSet).datasetOutputPath(targetFs.getUri().getPath()).ancestorsOwnerAndPermission(ancestorOwnerAndPermissionList).build();
            fileEntity.setSourceData((Descriptor)this.getSourceDataset(this.sourceFs));
            fileEntity.setDestinationData((Descriptor)this.getDestinationDataset(targetFs));
            copyEntities.add(fileEntity);
        }
        copyEntities.add(this.createPostPublishStep(this.dbName, this.inputTableName, this.properties));
        log.info("~{}.{}~ generated {} copy entities", new Object[]{this.dbName, this.inputTableName, copyEntities.size()});
        return copyEntities;
    }

    protected Map<Path, FileStatus> getFilePathsToFileStatus(FileSystem targetFs, CopyConfiguration copyConfig) throws IOException {
        IcebergTable icebergTable = this.getSrcIcebergTable();
        Function isPresentOnTarget = CheckedExceptionFunction.wrapToTunneled(pathStr -> copyConfig.getCopyContext().getFileStatus(targetFs, new Path(pathStr)).isPresent());
        IcebergSnapshotInfo currentSnapshotOverview = icebergTable.getCurrentSnapshotInfoOverviewOnly();
        if (currentSnapshotOverview.getMetadataPath().map(isPresentOnTarget).orElse(false).booleanValue() && ((Boolean)isPresentOnTarget.apply(currentSnapshotOverview.getManifestListPath())).booleanValue()) {
            log.info("~{}.{}~ skipping entire iceberg, since snapshot '{}' at '{}' and metadata '{}' both present on target", new Object[]{this.dbName, this.inputTableName, currentSnapshotOverview.getSnapshotId(), currentSnapshotOverview.getManifestListPath(), currentSnapshotOverview.getMetadataPath().orElse("<<ERROR: MISSING!>>")});
            return Maps.newHashMap();
        }
        Iterator<IcebergSnapshotInfo> icebergIncrementalSnapshotInfos = icebergTable.getIncrementalSnapshotInfosIterator();
        Iterator filePathsIterator = Iterators.concat((Iterator)Iterators.transform(icebergIncrementalSnapshotInfos, snapshotInfo -> {
            String manListPath = snapshotInfo.getManifestListPath();
            log.info("~{}.{}~ loaded snapshot '{}' at '{}' from metadata path: '{}'", new Object[]{this.dbName, this.inputTableName, snapshotInfo.getSnapshotId(), manListPath, snapshotInfo.getMetadataPath().orElse("<<inherited>>")});
            if (!((Boolean)isPresentOnTarget.apply(manListPath)).booleanValue()) {
                List<String> missingPaths = snapshotInfo.getSnapshotApexPaths();
                for (IcebergSnapshotInfo.ManifestFileInfo mfi : snapshotInfo.getManifestFiles()) {
                    if (((Boolean)isPresentOnTarget.apply(mfi.getManifestFilePath())).booleanValue()) continue;
                    missingPaths.add(mfi.getManifestFilePath());
                    missingPaths.addAll(mfi.getListedFilePaths());
                }
                log.info("~{}.{}~ snapshot '{}': collected {} additional source paths", new Object[]{this.dbName, this.inputTableName, snapshotInfo.getSnapshotId(), missingPaths.size()});
                return missingPaths.iterator();
            }
            log.info("~{}.{}~ snapshot '{}' already present on target... skipping (including contents)", new Object[]{this.dbName, this.inputTableName, snapshotInfo.getSnapshotId()});
            Optional<String> metadataPath = snapshotInfo.getMetadataPath();
            Optional<String> nonReplicatedMetadataPath = metadataPath.filter(p -> (Boolean)isPresentOnTarget.apply(p) == false);
            metadataPath.ifPresent(ignore -> log.info("~{}.{}~ metadata IS {} already present on target", new Object[]{this.dbName, this.inputTableName, nonReplicatedMetadataPath.isPresent() ? "NOT" : "ALSO"}));
            return nonReplicatedMetadataPath.map(p -> Lists.newArrayList((Object[])new String[]{p}).iterator()).orElse(Collections.emptyIterator());
        }));
        HashMap results = Maps.newHashMap();
        long numSourceFilesNotFound = 0L;
        Iterable filePathsIterable = () -> filePathsIterator;
        try {
            GrowthMilestoneTracker growthTracker = new GrowthMilestoneTracker();
            PathErrorConsolidator errorConsolidator = new PathErrorConsolidator();
            for (String pathString : filePathsIterable) {
                Path path = new Path(pathString);
                try {
                    results.put(path, this.sourceFs.getFileStatus(path));
                    if (!growthTracker.isAnotherMilestone((long)results.size())) continue;
                    log.info("~{}.{}~ collected file status on '{}' source paths", new Object[]{this.dbName, this.inputTableName, results.size()});
                }
                catch (FileNotFoundException fnfe) {
                    String total = ++numSourceFilesNotFound + " total";
                    String speculation = "either premature deletion broke time-travel or metadata read interleaved among delete";
                    errorConsolidator.prepLogMsg(path).ifPresent(msg -> log.warn("~{}.{}~ source {} ({}... {})", new Object[]{this.dbName, this.inputTableName, msg, speculation, total}));
                }
            }
        }
        catch (CheckedExceptionFunction.WrappedIOException wrapper) {
            wrapper.rethrowWrapped();
        }
        return results;
    }

    @VisibleForTesting
    static PathErrorConsolidator createPathErrorConsolidator() {
        return new PathErrorConsolidator();
    }

    protected FileSystem getSourceFileSystemFromFileStatus(FileStatus fileStatus, Configuration hadoopConfig) throws IOException {
        return fileStatus.getPath().getFileSystem(hadoopConfig);
    }

    protected DatasetDescriptor getSourceDataset(FileSystem sourceFs) {
        return this.srcIcebergTable.getDatasetDescriptor(sourceFs);
    }

    protected DatasetDescriptor getDestinationDataset(FileSystem targetFs) {
        return this.destIcebergTable.getDatasetDescriptor(targetFs);
    }

    private PostPublishStep createPostPublishStep(String dbName, String inputTableName, Properties properties) {
        IcebergRegisterStep icebergRegisterStep = new IcebergRegisterStep(dbName, inputTableName, properties);
        return new PostPublishStep(this.getFileSetId(), Maps.newHashMap(), icebergRegisterStep, 0);
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getInputTableName() {
        return this.inputTableName;
    }

    public IcebergTable getSrcIcebergTable() {
        return this.srcIcebergTable;
    }

    public IcebergTable getDestIcebergTable() {
        return this.destIcebergTable;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public FileSystem getSourceFs() {
        return this.sourceFs;
    }

    public boolean isShouldTolerateMissingSourceFiles() {
        return this.shouldTolerateMissingSourceFiles;
    }

    @NotThreadSafe
    protected static class PathErrorConsolidator {
        private final Map<Path, Boolean> consolidatedPathToWhetherErrorLogged = Maps.newHashMap();

        protected PathErrorConsolidator() {
        }

        public Optional<String> prepLogMsg(Path path) {
            Path consolidatedPath = this.calcPathConsolidation(path);
            Boolean hadAlreadyLoggedConsolidation = this.consolidatedPathToWhetherErrorLogged.get(consolidatedPath);
            if (!Boolean.valueOf(true).equals(hadAlreadyLoggedConsolidation)) {
                boolean shouldLogConsolidationNow = hadAlreadyLoggedConsolidation != null;
                this.consolidatedPathToWhetherErrorLogged.put(consolidatedPath, shouldLogConsolidationNow);
                String pathLogString = shouldLogConsolidationNow ? consolidatedPath.toString() + "/..." : path.toString();
                return Optional.of("path" + (shouldLogConsolidationNow ? "s" : " ") + " not found: '" + pathLogString + "'");
            }
            return Optional.empty();
        }

        protected Path calcPathConsolidation(Path path) {
            return path.getParent();
        }
    }
}

