/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.iceberg;

import java.util.Map;
import org.apache.gobblin.data.management.copy.iceberg.IcebergCatalog;
import org.apache.gobblin.data.management.copy.iceberg.IcebergTable;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.TableIdentifier;

public abstract class BaseIcebergCatalog
implements IcebergCatalog {
    protected final String catalogName;
    protected final Class<? extends Catalog> companionCatalogClass;

    protected BaseIcebergCatalog(String catalogName, Class<? extends Catalog> companionCatalogClass) {
        this.catalogName = catalogName;
        this.companionCatalogClass = companionCatalogClass;
    }

    @Override
    public IcebergTable openTable(String dbName, String tableName) {
        TableIdentifier tableId = TableIdentifier.of((String[])new String[]{dbName, tableName});
        return new IcebergTable(tableId, this.createTableOperations(tableId), this.getCatalogUri());
    }

    protected Catalog createCompanionCatalog(Map<String, String> properties, Configuration configuration) {
        return CatalogUtil.loadCatalog((String)this.companionCatalogClass.getName(), (String)this.catalogName, properties, (Configuration)configuration);
    }

    protected abstract TableOperations createTableOperations(TableIdentifier var1);
}

