/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.hive;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.apache.gobblin.data.management.copy.hive.HiveCopyEntityHelper;
import org.apache.gobblin.data.management.copy.hive.HiveDataset;
import org.apache.gobblin.util.PathUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.metadata.Partition;

public class HiveTargetPathHelper {
    public static final String COPY_TARGET_TABLE_ROOT = "hive.dataset.copy.target.table.root";
    public static final String COPY_TARGET_TABLE_PREFIX_TOBE_REPLACED = "hive.dataset.copy.target.table.prefixToBeReplaced";
    public static final String COPY_TARGET_TABLE_PREFIX_REPLACEMENT = "hive.dataset.copy.target.table.prefixReplacement";
    public static final String RELOCATE_DATA_FILES_KEY = "hive.dataset.copy.relocate.data.files";
    public static final String DEFAULT_RELOCATE_DATA_FILES = Boolean.toString(false);
    private final boolean relocateDataFiles;
    private final Optional<Path> targetTableRoot;
    private final Optional<Path> targetTablePrefixTobeReplaced;
    private final Optional<Path> targetTablePrefixReplacement;
    private final HiveDataset dataset;

    public HiveTargetPathHelper(HiveDataset dataset) {
        this.dataset = dataset;
        this.relocateDataFiles = Boolean.valueOf(this.dataset.getProperties().getProperty(RELOCATE_DATA_FILES_KEY, DEFAULT_RELOCATE_DATA_FILES));
        this.targetTableRoot = this.dataset.getProperties().containsKey(COPY_TARGET_TABLE_ROOT) ? Optional.of((Object)HiveTargetPathHelper.resolvePath(this.dataset.getProperties().getProperty(COPY_TARGET_TABLE_ROOT), this.dataset.getTable().getDbName(), this.dataset.getTable().getTableName())) : Optional.absent();
        this.targetTablePrefixTobeReplaced = this.dataset.getProperties().containsKey(COPY_TARGET_TABLE_PREFIX_TOBE_REPLACED) ? Optional.of((Object)new Path(this.dataset.getProperties().getProperty(COPY_TARGET_TABLE_PREFIX_TOBE_REPLACED))) : Optional.absent();
        this.targetTablePrefixReplacement = this.dataset.getProperties().containsKey(COPY_TARGET_TABLE_PREFIX_REPLACEMENT) ? Optional.of((Object)new Path(this.dataset.getProperties().getProperty(COPY_TARGET_TABLE_PREFIX_REPLACEMENT))) : Optional.absent();
    }

    private static Path addPartitionToPath(Path path, Partition partition) {
        for (String partitionValue : partition.getValues()) {
            path = new Path(path, partitionValue);
        }
        return path;
    }

    protected static Path resolvePath(String pattern, String database, String table) {
        if ((pattern = pattern.replace("$DB", database)).contains("$TABLE")) {
            pattern = pattern.replace("$TABLE", table);
            return new Path(pattern);
        }
        return new Path(pattern, table);
    }

    public Path getTargetPath(Path sourcePath, FileSystem targetFs, Optional<Partition> partition, boolean isConcreteFile) {
        if (this.relocateDataFiles) {
            Preconditions.checkArgument((boolean)this.targetTableRoot.isPresent(), (String)"Must define %s to relocate data files.", (Object)COPY_TARGET_TABLE_ROOT);
            Path path = (Path)this.targetTableRoot.get();
            if (partition.isPresent()) {
                path = HiveTargetPathHelper.addPartitionToPath(path, (Partition)partition.get());
            }
            if (!isConcreteFile) {
                return targetFs.makeQualified(path);
            }
            return targetFs.makeQualified(new Path(path, sourcePath.getName()));
        }
        if (this.targetTablePrefixTobeReplaced.isPresent() || this.targetTablePrefixReplacement.isPresent()) {
            Preconditions.checkState((boolean)this.targetTablePrefixTobeReplaced.isPresent(), (Object)String.format("Must specify both %s option and %s option together", COPY_TARGET_TABLE_PREFIX_TOBE_REPLACED, COPY_TARGET_TABLE_PREFIX_REPLACEMENT));
            Preconditions.checkState((boolean)this.targetTablePrefixReplacement.isPresent(), (Object)String.format("Must specify both %s option and %s option together", COPY_TARGET_TABLE_PREFIX_TOBE_REPLACED, COPY_TARGET_TABLE_PREFIX_REPLACEMENT));
            Preconditions.checkState((!this.targetTableRoot.isPresent() ? 1 : 0) != 0, (Object)String.format("Can not specify the option %s with option %s ", COPY_TARGET_TABLE_ROOT, COPY_TARGET_TABLE_PREFIX_REPLACEMENT));
            Path targetPathWithoutSchemeAndAuthority = HiveCopyEntityHelper.replacedPrefix(sourcePath, (Path)this.targetTablePrefixTobeReplaced.get(), (Path)this.targetTablePrefixReplacement.get());
            return targetFs.makeQualified(targetPathWithoutSchemeAndAuthority);
        }
        if (this.targetTableRoot.isPresent()) {
            Preconditions.checkArgument((boolean)this.dataset.getTableRootPath().isPresent(), (Object)"Cannot move paths to a new root unless table has exactly one location.");
            Preconditions.checkArgument((boolean)PathUtils.isAncestor((Path)((Path)this.dataset.getTableRootPath().get()), (Path)sourcePath), (String)"When moving paths to a new root, all locations must be descendants of the table root location. Table root location: %s, file location: %s.", this.dataset.getTableRootPath(), (Object)sourcePath);
            Path relativePath = PathUtils.relativizePath((Path)sourcePath, (Path)((Path)this.dataset.getTableRootPath().get()));
            return targetFs.makeQualified(new Path((Path)this.targetTableRoot.get(), relativePath));
        }
        return targetFs.makeQualified(PathUtils.getPathWithoutSchemeAndAuthority((Path)sourcePath));
    }
}

