/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.hive;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.gobblin.config.client.ConfigClient;
import org.apache.gobblin.config.client.ConfigClientCache;
import org.apache.gobblin.config.client.ConfigClientUtils;
import org.apache.gobblin.config.client.api.ConfigStoreFactoryDoesNotExistsException;
import org.apache.gobblin.config.client.api.VersionStabilityPolicy;
import org.apache.gobblin.config.store.api.ConfigStoreCreationException;
import org.apache.gobblin.data.management.copy.hive.HiveDataset;
import org.apache.gobblin.data.management.copy.hive.WhitelistBlacklist;
import org.apache.gobblin.data.management.hive.HiveConfigClientUtils;
import org.apache.gobblin.dataset.IterableDatasetFinder;
import org.apache.gobblin.hive.HiveMetastoreClientPool;
import org.apache.gobblin.metrics.event.EventSubmitter;
import org.apache.gobblin.metrics.event.sla.SlaEventSubmitter;
import org.apache.gobblin.util.AutoReturnableObject;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.reflection.GobblinConstructorUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveDatasetFinder
implements IterableDatasetFinder<HiveDataset> {
    private static final Logger log = LoggerFactory.getLogger(HiveDatasetFinder.class);
    public static final String HIVE_DATASET_PREFIX = "hive.dataset";
    public static final String HIVE_METASTORE_URI_KEY = "hive.dataset.hive.metastore.uri";
    public static final String DB_KEY = "hive.dataset.database";
    public static final String TABLE_PATTERN_KEY = "hive.dataset.table.pattern";
    public static final String DEFAULT_TABLE_PATTERN = "*";
    public static final String TABLE_FILTER = "hive.dataset.tableFilter";
    public static final String HIVE_DATASET_CONFIG_PREFIX_KEY = "hive.dataset.configPrefix";
    private static final String DEFAULT_HIVE_DATASET_CONIFG_PREFIX = "";
    public static final String HIVE_DATASET_IS_BLACKLISTED_KEY = "is.blacklisted";
    private static final boolean DEFAULT_HIVE_DATASET_IS_BLACKLISTED_KEY = false;
    public static final String CONFIG_STORE_DATASET_URI_BUILDER_CLASS = "org.apache.gobblin.config.management.datasetUriBuilderClass";
    private static final String DATASET_FOUND = "DatasetFound";
    private static final String DATASET_ERROR = "DatasetError";
    private static final String FAILURE_CONTEXT = "FailureContext";
    protected final Properties properties;
    protected final HiveMetastoreClientPool clientPool;
    protected final FileSystem fs;
    private final WhitelistBlacklist whitelistBlacklist;
    private final Optional<EventSubmitter> eventSubmitter;
    protected Optional<String> configStoreUri;
    protected final Function<org.apache.hadoop.hive.metastore.api.Table, String> configStoreDatasetUriBuilder;
    protected final Optional<Predicate<org.apache.hadoop.hive.metastore.api.Table>> tableFilter;
    protected final String datasetConfigPrefix;
    protected final ConfigClient configClient;
    private final Config jobConfig;
    private static final Function<org.apache.hadoop.hive.metastore.api.Table, String> DEFAULT_CONFIG_STORE_DATASET_URI_BUILDER = new Function<org.apache.hadoop.hive.metastore.api.Table, String>(){

        public String apply(@Nonnull org.apache.hadoop.hive.metastore.api.Table table) {
            return HiveConfigClientUtils.getDatasetUri(table);
        }
    };

    public HiveDatasetFinder(FileSystem fs, Properties properties) throws IOException {
        this(fs, properties, HiveDatasetFinder.createClientPool(properties));
    }

    protected HiveDatasetFinder(FileSystem fs, Properties properties, ConfigClient configClient) throws IOException {
        this(fs, properties, HiveDatasetFinder.createClientPool(properties), null, configClient);
    }

    public HiveDatasetFinder(FileSystem fs, Properties properties, EventSubmitter eventSubmitter) throws IOException {
        this(fs, properties, HiveDatasetFinder.createClientPool(properties), eventSubmitter);
    }

    protected HiveDatasetFinder(FileSystem fs, Properties properties, HiveMetastoreClientPool clientPool) throws IOException {
        this(fs, properties, clientPool, null);
    }

    protected HiveDatasetFinder(FileSystem fs, Properties properties, HiveMetastoreClientPool clientPool, EventSubmitter eventSubmitter) throws IOException {
        this(fs, properties, clientPool, eventSubmitter, ConfigClientCache.getClient((VersionStabilityPolicy)VersionStabilityPolicy.STRONG_LOCAL_STABILITY));
    }

    protected HiveDatasetFinder(FileSystem fs, Properties properties, HiveMetastoreClientPool clientPool, EventSubmitter eventSubmitter, ConfigClient configClient) throws IOException {
        this.properties = properties;
        this.clientPool = clientPool;
        this.fs = fs;
        String whitelistKey = "hive.dataset.whitelist";
        Preconditions.checkArgument((properties.containsKey(DB_KEY) || properties.containsKey(whitelistKey) ? 1 : 0) != 0, (Object)String.format("Must specify %s or %s.", DB_KEY, whitelistKey));
        Config config = ConfigFactory.parseProperties((Properties)properties);
        this.whitelistBlacklist = properties.containsKey(DB_KEY) ? new WhitelistBlacklist(this.properties.getProperty(DB_KEY) + "." + this.properties.getProperty(TABLE_PATTERN_KEY, DEFAULT_TABLE_PATTERN), DEFAULT_HIVE_DATASET_CONIFG_PREFIX) : new WhitelistBlacklist(config.getConfig(HIVE_DATASET_PREFIX));
        this.eventSubmitter = Optional.fromNullable((Object)eventSubmitter);
        Optional optional = this.configStoreUri = StringUtils.isNotBlank((CharSequence)properties.getProperty("gobblin.config.management.store.uri")) ? Optional.of((Object)properties.getProperty("gobblin.config.management.store.uri")) : Optional.absent();
        if (!Boolean.valueOf(properties.getProperty("gobblin.config.management.store.enabled", "false")).booleanValue()) {
            this.configStoreUri = Optional.absent();
        }
        this.datasetConfigPrefix = properties.getProperty(HIVE_DATASET_CONFIG_PREFIX_KEY, DEFAULT_HIVE_DATASET_CONIFG_PREFIX);
        this.configClient = configClient;
        try {
            this.configStoreDatasetUriBuilder = properties.containsKey(CONFIG_STORE_DATASET_URI_BUILDER_CLASS) ? (Function)ConstructorUtils.invokeConstructor(Class.forName(properties.getProperty(CONFIG_STORE_DATASET_URI_BUILDER_CLASS)), (Object[])new Object[0]) : DEFAULT_CONFIG_STORE_DATASET_URI_BUILDER;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.jobConfig = ConfigUtils.propertiesToConfig((Properties)properties);
        String tableFilterPredicate = properties.getProperty(TABLE_FILTER);
        this.tableFilter = StringUtils.isNotEmpty((CharSequence)tableFilterPredicate) ? Optional.of((Object)((Predicate)GobblinConstructorUtils.invokeConstructor(Predicate.class, (String)tableFilterPredicate, (Object[])new Object[]{properties}))) : Optional.absent();
    }

    protected static HiveMetastoreClientPool createClientPool(Properties properties) throws IOException {
        return HiveMetastoreClientPool.get((Properties)properties, (Optional)Optional.fromNullable((Object)properties.getProperty(HIVE_METASTORE_URI_KEY)));
    }

    public Collection<DbAndTable> getTables() throws IOException {
        ArrayList tables = Lists.newArrayList();
        try (AutoReturnableObject client = this.clientPool.getClient();){
            Iterable databases = Iterables.filter((Iterable)((IMetaStoreClient)client.get()).getAllDatabases(), (Predicate)new Predicate<String>(){

                public boolean apply(String db) {
                    return HiveDatasetFinder.this.whitelistBlacklist.acceptDb(db);
                }
            });
            for (final String db : databases) {
                Iterable tableNames = Iterables.filter((Iterable)((IMetaStoreClient)client.get()).getAllTables(db), (Predicate)new Predicate<String>(){

                    public boolean apply(String table) {
                        return HiveDatasetFinder.this.whitelistBlacklist.acceptTable(db, table);
                    }
                });
                for (String tableName : tableNames) {
                    tables.add(new DbAndTable(db, tableName));
                }
            }
        }
        catch (Exception exc) {
            throw new IOException(exc);
        }
        return tables;
    }

    public List<HiveDataset> findDatasets() throws IOException {
        return Lists.newArrayList(this.getDatasetsIterator());
    }

    public Iterator<HiveDataset> getDatasetsIterator() throws IOException {
        return new AbstractIterator<HiveDataset>(){
            private Iterator<DbAndTable> tables;
            {
                this.tables = HiveDatasetFinder.this.getTables().iterator();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected HiveDataset computeNext() {
                while (this.tables.hasNext()) {
                    DbAndTable dbAndTable = this.tables.next();
                    try {
                        AutoReturnableObject client = HiveDatasetFinder.this.clientPool.getClient();
                        Throwable throwable = null;
                        try {
                            Config datasetConfig;
                            org.apache.hadoop.hive.metastore.api.Table table = ((IMetaStoreClient)client.get()).getTable(dbAndTable.getDb(), dbAndTable.getTable());
                            if (HiveDatasetFinder.this.tableFilter.isPresent() && !((Predicate)HiveDatasetFinder.this.tableFilter.get()).apply((Object)table) || ConfigUtils.getBoolean((Config)(datasetConfig = HiveDatasetFinder.this.getDatasetConfig(table)), (String)HiveDatasetFinder.HIVE_DATASET_IS_BLACKLISTED_KEY, (boolean)false)) continue;
                            if (HiveDatasetFinder.this.eventSubmitter.isPresent()) {
                                SlaEventSubmitter.builder().datasetUrn(dbAndTable.toString()).eventSubmitter((EventSubmitter)HiveDatasetFinder.this.eventSubmitter.get()).eventName(HiveDatasetFinder.DATASET_FOUND).build().submit();
                            }
                            HiveDataset hiveDataset = HiveDatasetFinder.this.createHiveDataset(table, datasetConfig);
                            return hiveDataset;
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (client == null) continue;
                            if (throwable != null) {
                                try {
                                    client.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                continue;
                            }
                            client.close();
                        }
                    }
                    catch (IllegalArgumentException e) {
                        Throwables.propagate((Throwable)e);
                    }
                    catch (Throwable t) {
                        log.error(String.format("Failed to create HiveDataset for table %s.%s", dbAndTable.getDb(), dbAndTable.getTable()), t);
                        if (!HiveDatasetFinder.this.eventSubmitter.isPresent()) continue;
                        SlaEventSubmitter.builder().datasetUrn(dbAndTable.toString()).eventSubmitter((EventSubmitter)HiveDatasetFinder.this.eventSubmitter.get()).eventName(HiveDatasetFinder.DATASET_ERROR).additionalMetadata(HiveDatasetFinder.FAILURE_CONTEXT, t.toString()).build().submit();
                    }
                }
                return (HiveDataset)this.endOfData();
            }
        };
    }

    @Deprecated
    protected HiveDataset createHiveDataset(org.apache.hadoop.hive.metastore.api.Table table) throws IOException {
        return this.createHiveDataset(table, ConfigFactory.empty());
    }

    protected HiveDataset createHiveDataset(org.apache.hadoop.hive.metastore.api.Table table, Config datasetConfig) throws IOException {
        return new HiveDataset(this.fs, this.clientPool, new Table(table), this.properties, datasetConfig);
    }

    public Path commonDatasetRoot() {
        return new Path("/");
    }

    private Config getDatasetConfig(org.apache.hadoop.hive.metastore.api.Table table) throws ConfigStoreFactoryDoesNotExistsException, ConfigStoreCreationException, URISyntaxException {
        Optional runtimeConfig = ConfigClientUtils.getOptionalRuntimeConfig((Properties)this.properties);
        Config datasetConfig = this.configStoreUri.isPresent() ? (runtimeConfig.isPresent() ? this.configClient.getConfig((String)this.configStoreUri.get() + "/" + (String)this.configStoreDatasetUriBuilder.apply((Object)table), runtimeConfig) : this.configClient.getConfig((String)this.configStoreUri.get() + "/" + (String)this.configStoreDatasetUriBuilder.apply((Object)table))) : this.jobConfig;
        return StringUtils.isBlank((CharSequence)this.datasetConfigPrefix) ? datasetConfig : ConfigUtils.getConfig((Config)datasetConfig, (String)this.datasetConfigPrefix, (Config)ConfigFactory.empty());
    }

    public Properties getProperties() {
        return this.properties;
    }

    public static class DbAndTable {
        private final String db;
        private final String table;

        public String toString() {
            return String.format("%s.%s", this.db, this.table);
        }

        public DbAndTable(String db, String table) {
            this.db = db;
            this.table = table;
        }

        public String getDb() {
            return this.db;
        }

        public String getTable() {
            return this.table;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DbAndTable)) {
                return false;
            }
            DbAndTable other = (DbAndTable)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$db = this.getDb();
            String other$db = other.getDb();
            if (this$db == null ? other$db != null : !this$db.equals(other$db)) {
                return false;
            }
            String this$table = this.getTable();
            String other$table = other.getTable();
            return !(this$table == null ? other$table != null : !this$table.equals(other$table));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DbAndTable;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $db = this.getDb();
            result = result * 59 + ($db == null ? 43 : $db.hashCode());
            String $table = this.getTable();
            result = result * 59 + ($table == null ? 43 : $table.hashCode());
            return result;
        }
    }
}

