/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.gobblin.data.management.copy.RecursiveCopyableDataset;
import org.apache.gobblin.util.PathUtils;
import org.apache.gobblin.util.filters.AndPathFilter;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class UnixTimestampRecursiveCopyableDataset
extends RecursiveCopyableDataset {
    private static final String CONFIG_PREFIX = "gobblin.copy.recursive";
    public static final String VERSION_SELECTION_POLICY = "gobblin.copy.recursive.version.selection.policy";
    public static final String TIMESTAMP_REGEEX = "gobblin.copy.recursive.timestamp.pattern";
    public static final String DEFAULT_TIMESTAMP_REGEX = ".*/([0-9]{13}).*/.*";
    private final String lookbackTime;
    private final Period lookbackPeriod;
    private final LocalDateTime currentTime;
    private final VersionSelectionPolicy versionSelectionPolicy;
    private final DateTimeZone dateTimeZone;
    private final Pattern timestampPattern;

    public UnixTimestampRecursiveCopyableDataset(FileSystem fs, Path rootPath, Properties properties, Path glob) {
        super(fs, rootPath, properties, glob);
        this.lookbackTime = properties.getProperty("gobblin.copy.recursive.lookback.time");
        this.versionSelectionPolicy = VersionSelectionPolicy.valueOf(properties.getProperty(VERSION_SELECTION_POLICY).toUpperCase());
        PeriodFormatter periodFormatter = new PeriodFormatterBuilder().appendDays().appendSuffix("d").toFormatter();
        this.lookbackPeriod = periodFormatter.parsePeriod(this.lookbackTime);
        String timestampRegex = properties.getProperty(TIMESTAMP_REGEEX, DEFAULT_TIMESTAMP_REGEX);
        this.timestampPattern = Pattern.compile(timestampRegex);
        this.dateTimeZone = DateTimeZone.forID((String)properties.getProperty("gobblin.copy.recursive.datetime.timezone", "America/Los_Angeles"));
        this.currentTime = LocalDateTime.now((DateTimeZone)this.dateTimeZone);
    }

    @Override
    protected List<FileStatus> getFilesAtPath(FileSystem fs, Path path, PathFilter fileFilter) throws IOException {
        AndPathFilter andPathFilter = new AndPathFilter(new PathFilter[]{fileFilter, new TimestampPathFilter()});
        List<FileStatus> files = super.getFilesAtPath(fs, path, (PathFilter)andPathFilter);
        if (VersionSelectionPolicy.ALL == this.versionSelectionPolicy) {
            return files;
        }
        HashMap pathTimestampFilesMap = new HashMap();
        for (FileStatus fileStatus : files) {
            Map timestampFilesMap;
            Long unixTimestamp;
            LocalDate localDate;
            String relativePath = PathUtils.relativizePath((Path)PathUtils.getPathWithoutSchemeAndAuthority((Path)fileStatus.getPath()), (Path)this.datasetRoot()).toString();
            Matcher matcher = this.timestampPattern.matcher(relativePath);
            if (!matcher.matches()) continue;
            String timestampStr = matcher.group(1);
            String rootPath = relativePath.substring(0, relativePath.indexOf(timestampStr));
            ImmutablePair key = new ImmutablePair((Object)rootPath, (Object)(localDate = new LocalDateTime((Object)(unixTimestamp = Long.valueOf(Long.parseLong(timestampStr))), this.dateTimeZone).toLocalDate()));
            if (!pathTimestampFilesMap.containsKey(key)) {
                pathTimestampFilesMap.put(key, new TreeMap());
            }
            if (!(timestampFilesMap = (Map)pathTimestampFilesMap.get(key)).containsKey(unixTimestamp)) {
                timestampFilesMap.put(unixTimestamp, Lists.newArrayList());
            }
            List filesStatuses = (List)timestampFilesMap.get(unixTimestamp);
            filesStatuses.add(fileStatus);
        }
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        block5: for (TreeMap timestampFileStatus : pathTimestampFilesMap.values()) {
            if (timestampFileStatus.size() <= 0) continue;
            switch (this.versionSelectionPolicy) {
                case EARLIEST: {
                    result.addAll((Collection)timestampFileStatus.firstEntry().getValue());
                    continue block5;
                }
                case LATEST: {
                    result.addAll((Collection)timestampFileStatus.lastEntry().getValue());
                    continue block5;
                }
            }
            throw new RuntimeException("Unsupported version selection policy");
        }
        return result;
    }

    class TimestampPathFilter
    implements PathFilter {
        TimestampPathFilter() {
        }

        public boolean accept(Path path) {
            LocalDate endDate = UnixTimestampRecursiveCopyableDataset.this.currentTime.toLocalDate();
            LocalDate startDate = endDate.minus((ReadablePeriod)UnixTimestampRecursiveCopyableDataset.this.lookbackPeriod);
            Path relativePath = PathUtils.relativizePath((Path)PathUtils.getPathWithoutSchemeAndAuthority((Path)path), (Path)UnixTimestampRecursiveCopyableDataset.this.datasetRoot());
            Matcher matcher = UnixTimestampRecursiveCopyableDataset.this.timestampPattern.matcher(relativePath.toString());
            if (!matcher.matches()) {
                return false;
            }
            Long timestamp = Long.parseLong(matcher.group(1));
            LocalDate dateOfTimestamp = new LocalDateTime((Object)timestamp, UnixTimestampRecursiveCopyableDataset.this.dateTimeZone).toLocalDate();
            return dateOfTimestamp != null && !dateOfTimestamp.isAfter((ReadablePartial)endDate) && !dateOfTimestamp.isEqual((ReadablePartial)startDate) && !dateOfTimestamp.isBefore((ReadablePartial)startDate);
        }
    }

    private static enum VersionSelectionPolicy {
        EARLIEST,
        LATEST,
        ALL;

    }
}

