/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.gobblin.data.management.copy.ManifestBasedDataset;
import org.apache.gobblin.dataset.IterableDatasetFinder;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class ManifestBasedDatasetFinder
implements IterableDatasetFinder<ManifestBasedDataset> {
    public static final String CONFIG_PREFIX = "gobblin.copy.manifestBased";
    public static final String MANIFEST_LOCATION = "gobblin.copy.manifestBased.manifest.location";
    private final FileSystem fs;
    private final List<Path> manifestLocations;
    private final Properties properties;

    public ManifestBasedDatasetFinder(FileSystem fs, Properties properties) {
        Preconditions.checkArgument((boolean)properties.containsKey(MANIFEST_LOCATION), (Object)"Manifest location key required in config. Please set gobblin.copy.manifestBased.manifest.location");
        this.fs = fs;
        this.manifestLocations = new ArrayList<Path>();
        this.properties = properties;
        Splitter.on((char)',').trimResults().split((CharSequence)properties.getProperty(MANIFEST_LOCATION)).forEach(s -> this.manifestLocations.add(new Path(s)));
    }

    public List<ManifestBasedDataset> findDatasets() throws IOException {
        return this.manifestLocations.stream().map(p -> new ManifestBasedDataset(this.fs, (Path)p, this.properties)).collect(Collectors.toList());
    }

    public Path commonDatasetRoot() {
        return new Path("/");
    }

    public Iterator<ManifestBasedDataset> getDatasetsIterator() throws IOException {
        return this.manifestLocations.stream().map(p -> new ManifestBasedDataset(this.fs, (Path)p, this.properties)).iterator();
    }
}

