/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy;

import com.google.common.base.Optional;
import java.io.InputStream;
import lombok.NonNull;
import org.apache.gobblin.data.management.copy.CopyableFile;
import org.apache.gobblin.data.management.copy.splitter.DistcpFileSplitter;

public class FileAwareInputStream {
    private CopyableFile file;
    private InputStream inputStream;
    private Optional<DistcpFileSplitter.Split> split = Optional.absent();

    public FileAwareInputStream(@NonNull CopyableFile file, @NonNull InputStream inputStream, Optional<DistcpFileSplitter.Split> split) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        this.file = file;
        this.inputStream = inputStream;
        this.split = split == null ? Optional.absent() : split;
    }

    public String toString() {
        return this.file.toString();
    }

    public static FileAwareInputStreamBuilder builder() {
        return new FileAwareInputStreamBuilder();
    }

    public FileAwareInputStreamBuilder toBuilder() {
        return new FileAwareInputStreamBuilder().file(this.file).inputStream(this.inputStream).split(this.split);
    }

    public CopyableFile getFile() {
        return this.file;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public Optional<DistcpFileSplitter.Split> getSplit() {
        return this.split;
    }

    public static class FileAwareInputStreamBuilder {
        private CopyableFile file;
        private InputStream inputStream;
        private Optional<DistcpFileSplitter.Split> split;

        FileAwareInputStreamBuilder() {
        }

        public FileAwareInputStreamBuilder file(@NonNull CopyableFile file) {
            if (file == null) {
                throw new NullPointerException("file is marked non-null but is null");
            }
            this.file = file;
            return this;
        }

        public FileAwareInputStreamBuilder inputStream(@NonNull InputStream inputStream) {
            if (inputStream == null) {
                throw new NullPointerException("inputStream is marked non-null but is null");
            }
            this.inputStream = inputStream;
            return this;
        }

        public FileAwareInputStreamBuilder split(Optional<DistcpFileSplitter.Split> split) {
            this.split = split;
            return this;
        }

        public FileAwareInputStream build() {
            return new FileAwareInputStream(this.file, this.inputStream, this.split);
        }

        public String toString() {
            return "FileAwareInputStream.FileAwareInputStreamBuilder(file=" + this.file + ", inputStream=" + this.inputStream + ", split=" + this.split + ")";
        }
    }
}

