/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class CopyManifest {
    private static final String MISSING_FN_MESSAGE = "fileName cannot be null";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type CopyableUnitListType = new TypeToken<ArrayList<CopyableUnit>>(){}.getType();
    public final ArrayList<CopyableUnit> _copyableUnits;

    public CopyManifest() {
        this._copyableUnits = new ArrayList();
    }

    public CopyManifest(ArrayList<CopyableUnit> copyableUnits) {
        this._copyableUnits = copyableUnits;
    }

    public void add(CopyableUnit copyableUnit) {
        this._copyableUnits.add(copyableUnit);
    }

    public static CopyManifest read(FileSystem fs, Path path) throws IOException {
        JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader((InputStream)fs.open(path), "UTF-8"));
        return new CopyManifest((ArrayList)GSON.fromJson(jsonReader, CopyableUnitListType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(FileSystem fs, Path path) throws IOException {
        try (FSDataOutputStream out = null;){
            String outputJson = GSON.toJson(this._copyableUnits, CopyableUnitListType);
            out = fs.create(path, true);
            out.write(outputJson.getBytes(StandardCharsets.UTF_8));
        }
    }

    public static CopyableUnitIterator getReadIterator(FileSystem fs, Path path) throws IOException {
        return new CopyableUnitIterator(fs, path);
    }

    public static class CopyableUnitIterator
    implements Iterator {
        JsonReader reader;

        public CopyableUnitIterator(FileSystem fs, Path path) throws IOException {
            this.reader = new JsonReader((Reader)new InputStreamReader((InputStream)fs.open(path), "UTF-8"));
            this.reader.beginArray();
        }

        @Override
        public boolean hasNext() {
            try {
                return this.reader.hasNext();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }

        public CopyableUnit next() {
            CopyableUnit copyableUnit = (CopyableUnit)GSON.fromJson(this.reader, CopyableUnit.class);
            if (copyableUnit.fileName == null) {
                throw new IllegalArgumentException(CopyManifest.MISSING_FN_MESSAGE);
            }
            return copyableUnit;
        }

        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.endArray();
                this.reader.close();
            }
        }
    }

    public static class CopyableUnit {
        public final String fileName;
        public final String fileGroup;
        public final Long fileSizeInBytes;
        public final Long fileModificationTime;

        public CopyableUnit(String fileName, String fileGroup, Long fileSizeInBytes, Long fileModificationTime) {
            this.fileName = fileName;
            this.fileGroup = fileGroup;
            this.fileSizeInBytes = fileSizeInBytes;
            this.fileModificationTime = fileModificationTime;
            if (this.fileName == null) {
                throw new IllegalArgumentException(CopyManifest.MISSING_FN_MESSAGE);
            }
        }
    }
}

