/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.conversion.hive.source;

import com.google.common.base.Optional;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.data.management.conversion.hive.source.HiveSource;
import org.apache.gobblin.data.management.copy.hive.HiveDataset;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.metadata.Partition;

public class HiveWorkUnit
extends WorkUnit {
    private static final String PREFIX = "hive.source.dataset";
    private static final String HIVE_DATASET_SERIALIZED_KEY = "hive.source.dataset.serialized";
    private static final String HIVE_TABLE_SCHEMA_URL_KEY = "hive.source.dataset.table.schemaUrl";
    private static final String HIVE_TABLE_LOCATION_KEY = "hive.source.dataset.table.location";
    private static final String HIVE_PARTITION_SCHEMA_URL_KEY = "hive.source.dataset.partition.schemaUrl";
    private static final String HIVE_PARTITION_NAME_KEY = "hive.source.dataset.partition.name";
    private static final String HIVE_PARTITION_LOCATION_KEY = "hive.source.dataset.partition.location";
    private static final String HIVE_PARTITION_KEYS = "hive.source.dataset.partition.keys";
    private static final Gson GSON = new Gson();
    private static final Type FIELD_SCHEMA_TYPE = new TypeToken<List<FieldSchema>>(){}.getType();

    public HiveWorkUnit() {
    }

    public HiveWorkUnit(WorkUnit workunit) {
        super(workunit);
    }

    public HiveWorkUnit(HiveDataset hiveDataset) {
        this.setHiveDataset(hiveDataset);
        if (hiveDataset.getTable().getTableType() != TableType.VIRTUAL_VIEW) {
            this.setTableLocation(hiveDataset.getTable().getSd().getLocation());
        }
    }

    public HiveWorkUnit(HiveDataset hiveDataset, Partition partition) {
        this(hiveDataset);
        this.setPartitionName(partition.getName());
        this.setPartitionLocation(partition.getLocation());
        this.setPartitionKeys(partition.getTable().getPartitionKeys());
    }

    public void setDatasetUrn(String datasetUrn) {
        this.setProp("dataset.urn", datasetUrn);
    }

    public String getDatasetUrn(String datasetUrn) {
        return this.getProp("dataset.urn");
    }

    public void setHiveDataset(HiveDataset hiveDataset) {
        this.setProp(HIVE_DATASET_SERIALIZED_KEY, HiveSource.GENERICS_AWARE_GSON.toJson((Object)hiveDataset, HiveDataset.class));
        this.setDatasetUrn(hiveDataset.getTable().getCompleteName());
    }

    public HiveDataset getHiveDataset() {
        return (HiveDataset)HiveSource.GENERICS_AWARE_GSON.fromJson(this.getProp(HIVE_DATASET_SERIALIZED_KEY), HiveDataset.class);
    }

    public void setTableSchemaUrl(Path schemaUrl) {
        this.setProp(HIVE_TABLE_SCHEMA_URL_KEY, schemaUrl.toString());
    }

    public Path getTableSchemaUrl() {
        return new Path(this.getProp(HIVE_TABLE_SCHEMA_URL_KEY));
    }

    public void setPartitionSchemaUrl(Path schemaUrl) {
        this.setProp(HIVE_PARTITION_SCHEMA_URL_KEY, schemaUrl.toString());
    }

    public Optional<Path> getPartitionSchemaUrl() {
        return StringUtils.isNotBlank((CharSequence)this.getProp(HIVE_PARTITION_SCHEMA_URL_KEY)) ? Optional.of((Object)new Path(this.getProp(HIVE_PARTITION_SCHEMA_URL_KEY))) : Optional.absent();
    }

    public void setPartitionName(String partitionName) {
        this.setProp(HIVE_PARTITION_NAME_KEY, partitionName);
    }

    public Optional<String> getPartitionName() {
        return Optional.fromNullable((Object)this.getProp(HIVE_PARTITION_NAME_KEY));
    }

    public void setTableLocation(String partitionLocation) {
        this.setProp(HIVE_TABLE_LOCATION_KEY, partitionLocation);
    }

    public Optional<String> getTableLocation() {
        return Optional.fromNullable((Object)this.getProp(HIVE_TABLE_LOCATION_KEY));
    }

    public void setPartitionLocation(String partitionLocation) {
        this.setProp(HIVE_PARTITION_LOCATION_KEY, partitionLocation);
    }

    public Optional<String> getPartitionLocation() {
        return Optional.fromNullable((Object)this.getProp(HIVE_PARTITION_LOCATION_KEY));
    }

    public void setPartitionKeys(List<FieldSchema> partitionKeys) {
        this.setProp(HIVE_PARTITION_KEYS, GSON.toJson(partitionKeys, FIELD_SCHEMA_TYPE));
    }

    public Optional<List<FieldSchema>> getPartitionKeys() {
        String serialzed = this.getProp(HIVE_PARTITION_KEYS);
        if (serialzed == null) {
            return Optional.absent();
        }
        List deserialized = (List)GSON.fromJson(serialzed, FIELD_SCHEMA_TYPE);
        return Optional.of((Object)deserialized);
    }
}

