/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.conversion.hive.source;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.data.management.conversion.hive.source.HiveAvroToOrcSource;
import org.apache.gobblin.source.extractor.extract.LongWatermark;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.apache.hadoop.hive.ql.metadata.Partition;

public class BackfillHiveSource
extends HiveAvroToOrcSource {
    @VisibleForTesting
    public static final String BACKFILL_SOURCE_PARTITION_WHITELIST_KEY = "hive.backfillSource.partitions.whitelist";
    private Set<String> partitionsWhitelist;

    @VisibleForTesting
    public void initBackfillHiveSource(SourceState state) {
        this.partitionsWhitelist = Sets.newHashSet((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)state.getProp(BACKFILL_SOURCE_PARTITION_WHITELIST_KEY, "")));
    }

    @Override
    public List<WorkUnit> getWorkunits(SourceState state) {
        this.initBackfillHiveSource(state);
        return super.getWorkunits(state);
    }

    @Override
    public boolean shouldCreateWorkunit(long createTime, long updateTime, LongWatermark lowWatermark) {
        return true;
    }

    @Override
    public boolean shouldCreateWorkunit(Partition sourcePartition, LongWatermark lowWatermark) {
        if (!this.partitionsWhitelist.isEmpty()) {
            return this.partitionsWhitelist.contains(sourcePartition.getCompleteName());
        }
        return true;
    }

    @Override
    public boolean isOlderThanLookback(Partition partition) {
        if (!this.partitionsWhitelist.isEmpty()) {
            return false;
        }
        return super.isOlderThanLookback(partition);
    }
}

