/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.conversion.hive.provider;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.data.management.conversion.hive.provider.HiveUnitUpdateProvider;
import org.apache.gobblin.data.management.conversion.hive.provider.UpdateNotFoundException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DatePatternUpdateProvider
implements HiveUnitUpdateProvider {
    @Override
    public long getUpdateTime(Partition partition) throws UpdateNotFoundException {
        return this.parseDateForLocation(partition.getTPartition().getSd().getLocation());
    }

    @Override
    public long getUpdateTime(Table table) throws UpdateNotFoundException {
        return this.parseDateForLocation(table.getTTable().getSd().getLocation());
    }

    private long parseDateForLocation(String location) throws UpdateNotFoundException {
        for (Patterns pattern : Patterns.values()) {
            String dateString = StringUtils.substringAfterLast((String)location, (String)pattern.prefix);
            if (!StringUtils.isNotBlank((CharSequence)dateString)) continue;
            try {
                return pattern.dateFormat.parseMillis(dateString);
            }
            catch (IllegalArgumentException | UnsupportedOperationException e) {
                throw new UpdateNotFoundException(String.format("Failed parsing date string %s", dateString));
            }
        }
        throw new UpdateNotFoundException(String.format("Path %s does not match any date pattern %s", location, Arrays.toString((Object[])Patterns.values())));
    }

    private static enum Patterns {
        DAILY("/daily/", "yyyy/MM/dd"),
        DAILY_LATE("/daily_late/", "yyyy/MM/dd"),
        HOURLY("/hourly/", "yyyy/MM/dd/hh"),
        HOURLY_LATE("/hourly_late/", "yyyy/MM/dd/hh"),
        HOURLY_DEDUPED("/hourly_deduped/", "yyyy/MM/dd/hh");

        private final String prefix;
        private final DateTimeFormatter dateFormat;

        private Patterns(String prefix, String patternString) {
            this.prefix = prefix;
            this.dateFormat = DateTimeFormat.forPattern((String)patternString).withZone(DateTimeZone.forID((String)"America/Los_Angeles"));
        }

        public String toString() {
            return "DatePatternUpdateProvider.Patterns." + this.name() + "(prefix=" + this.prefix + ", dateFormat=" + this.dateFormat + ")";
        }
    }
}

