/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.conversion.hive.events;

import java.util.List;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.extractor.extract.LongWatermark;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public class EventWorkunitUtils {
    public static final String IS_WATERMARK_WORKUNIT_KEY = "hive.source.watermark.isWatermarkWorkUnit";

    public static void setTableSlaEventMetadata(WorkUnit state, Table table, long updateTime, long lowWatermark, long beginGetWorkunitsTime) {
        state.setProp("event.sla.datasetUrn", (Object)state.getProp("dataset.urn"));
        state.setProp("event.sla.partition", (Object)table.getCompleteName());
        state.setProp("event.sla.upstreamTimestamp", (Object)String.valueOf(updateTime));
        state.setProp("event.sla.originTimestamp", (Object)System.currentTimeMillis());
        state.setProp("event.sla.additionalMetadata.workunitCreateTime", (Object)state.getProp("event.sla.originTimestamp"));
        state.setProp("event.sla.additionalMetadata.beginGetWorkunitsTime", (Object)beginGetWorkunitsTime);
        state.setProp("event.sla.previousPublishTs", (Object)lowWatermark);
    }

    public static void setPartitionSlaEventMetadata(WorkUnit state, Table table, Partition partition, long updateTime, long lowWatermark, long beginGetWorkunitsTime) {
        state.setProp("event.sla.datasetUrn", (Object)state.getProp("dataset.urn"));
        state.setProp("event.sla.partition", (Object)partition.getName());
        state.setProp("event.sla.upstreamTimestamp", (Object)String.valueOf(updateTime));
        state.setProp("event.sla.originTimestamp", (Object)System.currentTimeMillis());
        state.setProp("event.sla.additionalMetadata.workunitCreateTime", (Object)state.getProp("event.sla.originTimestamp"));
        state.setProp("event.sla.previousPublishTs", (Object)lowWatermark);
        state.setProp("event.sla.additionalMetadata.beginGetWorkunitsTime", (Object)beginGetWorkunitsTime);
        state.setProp("event.sla.additionalMetadata.sourceDataLocation", (Object)partition.getDataLocation());
    }

    public static void setEvolutionMetadata(State state, List<String> evolutionDDLs) {
        state.setProp("event.sla.additionalMetadata.schemaEvolutionDDLNum", (Object)(evolutionDDLs == null ? 0 : evolutionDDLs.size()));
    }

    public static void setBeginDDLBuildTimeMetadata(State state, long time) {
        state.setProp("event.sla.additionalMetadata.beginDDLBuildTime", (Object)Long.toString(time));
    }

    public static void setEndDDLBuildTimeMetadata(State state, long time) {
        state.setProp("event.sla.additionalMetadata.endDDLBuildTime", (Object)Long.toString(time));
    }

    public static void setBeginConversionDDLExecuteTimeMetadata(State state, long time) {
        state.setProp("event.sla.additionalMetadata.beginConversionDDLExecuteTime", (Object)Long.toString(time));
    }

    public static void setEndConversionDDLExecuteTimeMetadata(State state, long time) {
        state.setProp("event.sla.additionalMetadata.endConversionDDLExecuteTime", (Object)Long.toString(time));
    }

    public static void setBeginPublishDDLExecuteTimeMetadata(State state, long time) {
        state.setProp("event.sla.additionalMetadata.beginPublishDDLExecuteTime", (Object)Long.toString(time));
    }

    public static void setEndPublishDDLExecuteTimeMetadata(State state, long time) {
        state.setProp("event.sla.additionalMetadata.endPublishDDLExecuteTime", (Object)Long.toString(time));
    }

    public static void setIsFirstPublishMetadata(WorkUnitState wus) {
        if (!Boolean.valueOf(wus.getPropAsBoolean(IS_WATERMARK_WORKUNIT_KEY)).booleanValue()) {
            LongWatermark previousWatermark = (LongWatermark)wus.getWorkunit().getLowWatermark(LongWatermark.class);
            wus.setProp("event.sla.isFirstPublish", (Object)(null == previousWatermark || previousWatermark.getValue() == 0L ? 1 : 0));
        }
    }
}

