/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.version.finder;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.gobblin.data.management.copy.hive.HiveDataset;
import org.apache.gobblin.data.management.copy.hive.HiveUtils;
import org.apache.gobblin.data.management.version.DatasetVersion;
import org.apache.gobblin.data.management.version.HiveDatasetVersion;
import org.apache.gobblin.data.management.version.finder.VersionFinder;
import org.apache.gobblin.dataset.Dataset;
import org.apache.gobblin.util.AutoReturnableObject;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHiveDatasetVersionFinder
implements VersionFinder<HiveDatasetVersion> {
    private static final Logger log = LoggerFactory.getLogger(AbstractHiveDatasetVersionFinder.class);

    @Override
    public Class<? extends DatasetVersion> versionClass() {
        return HiveDatasetVersion.class;
    }

    @Override
    public Collection<HiveDatasetVersion> findDatasetVersions(Dataset dataset) throws IOException {
        if (!(dataset instanceof HiveDataset)) {
            throw new IllegalArgumentException("HiveDatasetVersionFinder is only compatible with HiveDataset");
        }
        HiveDataset hiveDataset = (HiveDataset)dataset;
        if (!hiveDataset.getTable().isPartitioned()) {
            throw new IllegalArgumentException("HiveDatasetVersionFinder is only compatible with partitioned hive tables");
        }
        try (AutoReturnableObject client = hiveDataset.getClientPool().getClient();){
            List<Partition> partitions = HiveUtils.getPartitions((IMetaStoreClient)client.get(), hiveDataset.getTable(), (Optional<String>)Optional.absent());
            ArrayList arrayList = Lists.newArrayList((Iterable)Iterables.filter((Iterable)Iterables.transform(partitions, (Function)new Function<Partition, HiveDatasetVersion>(){

                public HiveDatasetVersion apply(Partition partition) {
                    try {
                        return AbstractHiveDatasetVersionFinder.this.getDatasetVersion(partition);
                    }
                    catch (Throwable e) {
                        log.warn(String.format("Failed to get DatasetVersion %s. Skipping.", partition.getCompleteName()), e);
                        return null;
                    }
                }
            }), (Predicate)Predicates.notNull()));
            return arrayList;
        }
    }

    protected abstract HiveDatasetVersion getDatasetVersion(Partition var1);
}

