/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention.source;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.runtime.retention.DatasetCleanerTaskFactory;
import org.apache.gobblin.runtime.task.TaskUtils;
import org.apache.gobblin.source.Source;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetCleanerSource
implements Source<Object, Object> {
    private static final Logger log = LoggerFactory.getLogger(DatasetCleanerSource.class);
    public static final String DATASET_CLEANER_SOURCE_PREFIX = "datasetCleanerSource";
    public static final String DATASET_CLEANER_CONFIGURATIONS = "datasetCleanerSource.configurations";

    public List<WorkUnit> getWorkunits(SourceState state) {
        ArrayList workUnits = Lists.newArrayList();
        Config config = ConfigUtils.propertiesToConfig((Properties)state.getProperties());
        Config sourceConfig = ConfigUtils.getConfigOrEmpty((Config)config, (String)DATASET_CLEANER_SOURCE_PREFIX);
        List configurationNames = ConfigUtils.getStringList((Config)config, (String)DATASET_CLEANER_CONFIGURATIONS);
        if (configurationNames.isEmpty()) {
            configurationNames = ImmutableList.of((Object)"DummyConfig");
        }
        for (String configurationName : configurationNames) {
            WorkUnit workUnit = WorkUnit.createEmpty();
            Config wuConfig = ConfigUtils.getConfigOrEmpty((Config)sourceConfig, (String)configurationName).withFallback((ConfigMergeable)sourceConfig).withFallback((ConfigMergeable)config);
            workUnit.setProps(ConfigUtils.configToProperties((Config)wuConfig), new Properties());
            TaskUtils.setTaskFactoryClass((State)workUnit, DatasetCleanerTaskFactory.class);
            workUnits.add(workUnit);
        }
        return workUnits;
    }

    public Extractor<Object, Object> getExtractor(WorkUnitState state) throws IOException {
        return null;
    }

    public void shutdown(SourceState state) {
    }
}

