/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.policy;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.gobblin.data.management.policy.VersionSelectionPolicy;
import org.apache.gobblin.data.management.version.FileSystemDatasetVersion;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.hadoop.fs.Path;

public class HiddenFilterSelectionPolicy
implements VersionSelectionPolicy<FileSystemDatasetVersion> {
    public static final String HIDDEN_FILTER_HIDDEN_FILE_PREFIX_KEY = "selection.hiddenFilter.hiddenFilePrefix";
    private static final String[] DEFAULT_HIDDEN_FILE_PREFIXES = new String[]{".", "_"};
    private List<String> hiddenFilePrefixes;

    public HiddenFilterSelectionPolicy(Config config) {
        this.hiddenFilePrefixes = config.hasPath(HIDDEN_FILTER_HIDDEN_FILE_PREFIX_KEY) ? ConfigUtils.getStringList((Config)config, (String)HIDDEN_FILTER_HIDDEN_FILE_PREFIX_KEY) : Arrays.asList(DEFAULT_HIDDEN_FILE_PREFIXES);
    }

    @Override
    public Class<? extends FileSystemDatasetVersion> versionClass() {
        return FileSystemDatasetVersion.class;
    }

    private boolean isPathHidden(Path path) {
        while (path != null) {
            String name = path.getName();
            for (String prefix : this.hiddenFilePrefixes) {
                if (!name.startsWith(prefix)) continue;
                return true;
            }
            path = path.getParent();
        }
        return false;
    }

    private Predicate<FileSystemDatasetVersion> getSelectionPredicate() {
        return new Predicate<FileSystemDatasetVersion>(){

            public boolean apply(FileSystemDatasetVersion version) {
                Set<Path> paths = version.getPaths();
                for (Path path : paths) {
                    Path p = Path.getPathWithoutSchemeAndAuthority((Path)path);
                    if (!HiddenFilterSelectionPolicy.this.isPathHidden(p)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    public Collection<FileSystemDatasetVersion> listSelectedVersions(List<FileSystemDatasetVersion> allVersions) {
        return Lists.newArrayList((Iterable)Collections2.filter(allVersions, this.getSelectionPredicate()));
    }
}

