/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.writer;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.data.management.copy.FileAwareInputStream;
import org.apache.gobblin.data.management.copy.writer.FileAwareInputStreamDataWriter;
import org.apache.gobblin.writer.DataWriter;
import org.apache.gobblin.writer.DataWriterBuilder;
import org.apache.hadoop.fs.Path;

public class FileAwareInputStreamDataWriterBuilder
extends DataWriterBuilder<String, FileAwareInputStream> {
    public final DataWriter<FileAwareInputStream> build() throws IOException {
        FileAwareInputStreamDataWriterBuilder.setJobSpecificOutputPaths(this.destination.getProperties());
        this.destination.getProperties().setProp("writer.file.path", (Object)this.writerId);
        return this.buildWriter();
    }

    protected DataWriter<FileAwareInputStream> buildWriter() throws IOException {
        return new FileAwareInputStreamDataWriter(this.destination.getProperties(), this.branches, this.branch, this.writerAttemptId);
    }

    public static synchronized void setJobSpecificOutputPaths(State state) {
        if (!StringUtils.containsIgnoreCase((String)state.getProp("writer.staging.dir"), (String)state.getProp("job.id"))) {
            state.setProp("writer.staging.dir", (Object)new Path(state.getProp("writer.staging.dir"), state.getProp("job.id")));
            state.setProp("writer.output.dir", (Object)new Path(state.getProp("writer.output.dir"), state.getProp("job.id")));
        }
    }
}

