/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.hive.filter;

import java.util.Arrays;
import java.util.Properties;
import org.apache.gobblin.data.management.copy.hive.HiveDataset;
import org.apache.gobblin.data.management.copy.hive.PartitionFilterGenerator;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookbackPartitionFilterGenerator
implements PartitionFilterGenerator {
    private static final Logger log = LoggerFactory.getLogger(LookbackPartitionFilterGenerator.class);
    public static final String PARTITION_COLUMN = "hive.dataset.partition.filter.datetime.column";
    public static final String LOOKBACK = "hive.dataset.partition.filter.datetime.lookback";
    public static final String DATETIME_FORMAT = "hive.dataset.partition.filter.datetime.format";
    private final Properties prop;

    public LookbackPartitionFilterGenerator(Properties properties) {
        this.prop = properties == null ? System.getProperties() : properties;
    }

    @Override
    public String getFilter(HiveDataset hiveDataset) {
        if (this.isValidConfig()) {
            String partitionColumn = this.prop.getProperty(PARTITION_COLUMN);
            Period lookback = Period.parse((String)this.prop.getProperty(LOOKBACK));
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)this.prop.getProperty(DATETIME_FORMAT));
            DateTime limitDate = new DateTime().minus((ReadablePeriod)lookback);
            String partitionFilter = String.format("%s >= \"%s\"", partitionColumn, formatter.print((ReadableInstant)limitDate));
            log.info(String.format("Getting partitions for %s using partition filter %s", hiveDataset == null ? "null" : hiveDataset.getTable().getCompleteName(), partitionFilter));
            return partitionFilter;
        }
        log.error(LookbackPartitionFilterGenerator.class.getName() + " requires the following properties " + Arrays.toString(new String[]{PARTITION_COLUMN, LOOKBACK, DATETIME_FORMAT}));
        return null;
    }

    private boolean isValidConfig() {
        return this.prop.containsKey(PARTITION_COLUMN) && this.prop.containsKey(DATETIME_FORMAT) && this.prop.containsKey(LOOKBACK);
    }
}

