/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.hive.filter;

import java.util.Arrays;
import java.util.Properties;
import org.apache.gobblin.data.management.copy.hive.HiveDataset;
import org.apache.gobblin.data.management.copy.hive.PartitionFilterGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateRangePartitionFilterGenerator
implements PartitionFilterGenerator {
    private static final Logger log = LoggerFactory.getLogger(DateRangePartitionFilterGenerator.class);
    public static final String PARTITION_COLUMN = "hive.dataset.partition.filter.datetime.column";
    public static final String START_DATE = "hive.dataset.partition.filter.datetime.startdate";
    public static final String END_DATE = "hive.dataset.partition.filter.datetime.enddate";
    private final Properties prop;

    public DateRangePartitionFilterGenerator(Properties properties) {
        this.prop = properties == null ? System.getProperties() : properties;
    }

    @Override
    public String getFilter(HiveDataset hiveDataset) {
        if (this.isValidConfig()) {
            String partitionColumn = this.prop.getProperty(PARTITION_COLUMN);
            String startDate = this.prop.getProperty(START_DATE);
            String endDate = this.prop.getProperty(END_DATE);
            String partitionFilter = String.format("%s between \"%s\" and \"%s\"", partitionColumn, startDate, endDate);
            log.info(String.format("Getting partitions for %s using partition filter %s", hiveDataset == null ? "null" : hiveDataset.getTable().getCompleteName(), partitionFilter));
            return partitionFilter;
        }
        log.error(DateRangePartitionFilterGenerator.class.getName() + " requires the following properties " + Arrays.toString(new String[]{PARTITION_COLUMN, START_DATE, END_DATE}));
        return null;
    }

    private boolean isValidConfig() {
        return this.prop.containsKey(PARTITION_COLUMN) && this.prop.containsKey(START_DATE) && this.prop.containsKey(END_DATE);
    }
}

