/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.trash;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.data.management.trash.GobblinProxiedTrash;
import org.apache.gobblin.data.management.trash.ProxiedTrash;
import org.apache.gobblin.data.management.trash.TrashFactory;
import org.apache.gobblin.util.Decorator;
import org.apache.gobblin.util.ExecutorsUtils;
import org.apache.gobblin.util.executors.ScalingThreadPoolExecutor;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncTrash
implements GobblinProxiedTrash,
Closeable,
Decorator {
    public static final String MAX_DELETING_THREADS_KEY = "gobblin.trash.async.max.deleting.threads";
    public static final int DEFAULT_MAX_DELETING_THREADS = 100;
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncTrash.class);
    private final ProxiedTrash innerTrash;
    private final ListeningExecutorService executor;

    public AsyncTrash(FileSystem fs, Properties properties) throws IOException {
        this(fs, properties, UserGroupInformation.getCurrentUser().getShortUserName());
    }

    public AsyncTrash(FileSystem fs, Properties properties, String user) throws IOException {
        int maxDeletingThreads = 100;
        if (properties.containsKey(MAX_DELETING_THREADS_KEY)) {
            maxDeletingThreads = Integer.parseInt(properties.getProperty(MAX_DELETING_THREADS_KEY));
        }
        this.innerTrash = TrashFactory.createProxiedTrash(fs, properties, user);
        this.executor = ExecutorsUtils.loggingDecorator((ExecutorService)MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)ScalingThreadPoolExecutor.newScalingThreadPool((int)0, (int)maxDeletingThreads, (long)100L, (ThreadFactory)ExecutorsUtils.newThreadFactory((Optional)Optional.of((Object)LOGGER), (Optional)Optional.of((Object)"Async-trash-delete-pool-%d")))));
    }

    @Override
    public boolean moveToTrashAsUser(Path path, String user) throws IOException {
        this.moveToTrashAsUserFuture(path, user);
        return true;
    }

    public ListenableFuture<Boolean> moveToTrashAsUserFuture(final Path path, final String user) {
        return this.executor.submit((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                return AsyncTrash.this.innerTrash.moveToTrashAsUser(path, user);
            }
        });
    }

    public boolean moveToTrashAsOwner(Path path) {
        this.moveToTrashAsOwnerFuture(path);
        return true;
    }

    public ListenableFuture<Boolean> moveToTrashAsOwnerFuture(final Path path) {
        return this.executor.submit((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                return AsyncTrash.this.innerTrash.moveToTrashAsOwner(path);
            }
        });
    }

    @Override
    public boolean moveToTrash(Path path) throws IOException {
        this.moveToTrashFuture(path);
        return true;
    }

    public ListenableFuture<Boolean> moveToTrashFuture(final Path path) {
        return this.executor.submit((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                return AsyncTrash.this.innerTrash.moveToTrash(path);
            }
        });
    }

    public Object getDecoratedObject() {
        return this.innerTrash;
    }

    @Override
    public void close() throws IOException {
        try {
            this.executor.shutdown();
            this.executor.awaitTermination(5L, TimeUnit.HOURS);
        }
        catch (InterruptedException ie) {
            this.executor.shutdownNow();
        }
    }
}

