/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention.version;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.gobblin.data.management.retention.dataset.CleanableDataset;
import org.apache.gobblin.data.management.version.DatasetVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VersionCleaner {
    private static final Logger log = LoggerFactory.getLogger(VersionCleaner.class);
    protected final CleanableDataset cleanableDataset;
    protected final DatasetVersion datasetVersion;

    public VersionCleaner(DatasetVersion datasetVersion, CleanableDataset cleanableDataset) {
        Preconditions.checkNotNull((Object)cleanableDataset);
        Preconditions.checkNotNull((Object)datasetVersion);
        this.cleanableDataset = cleanableDataset;
        this.datasetVersion = datasetVersion;
    }

    public abstract void preCleanAction() throws IOException;

    public abstract void clean() throws IOException;

    public abstract void postCleanAction() throws IOException;
}

