/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.dataset;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.gobblin.data.management.copy.CopyableFile;
import org.apache.gobblin.data.management.copy.CopyableFileFilter;
import org.apache.gobblin.dataset.Dataset;
import org.apache.gobblin.dataset.DatasetsFinder;
import org.apache.gobblin.dataset.IterableDatasetFinder;
import org.apache.gobblin.dataset.IterableDatasetFinderImpl;
import org.apache.gobblin.util.reflection.GobblinConstructorUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

public class DatasetUtils {
    public static final String CONFIGURATION_KEY_PREFIX = "gobblin.dataset.";
    public static final String DATASET_PROFILE_CLASS_KEY = "gobblin.dataset.profile.class";
    private static final String PATH_FILTER_KEY = "gobblin.dataset.path.filter.class";
    private static final String COPYABLE_FILE_FILTER_KEY = "gobblin.dataset.copyable.file.filter.class";
    private static final PathFilter ACCEPT_ALL_PATH_FILTER = new PathFilter(){

        public boolean accept(Path path) {
            return true;
        }
    };
    private static final CopyableFileFilter ACCEPT_ALL_COPYABLE_FILE_FILTER = new CopyableFileFilter(){

        @Override
        public Collection<CopyableFile> filter(FileSystem sourceFs, FileSystem targetFs, Collection<CopyableFile> copyableFiles) {
            return copyableFiles;
        }
    };

    public static <T extends Dataset> DatasetsFinder<T> instantiateDatasetFinder(Properties props, FileSystem fs, String default_class, Object ... additionalArgs) throws IOException {
        String className = default_class;
        if (props.containsKey(DATASET_PROFILE_CLASS_KEY)) {
            className = props.getProperty(DATASET_PROFILE_CLASS_KEY);
        }
        try {
            Class<?> datasetFinderClass = Class.forName(className);
            ArrayList args = Lists.newArrayList((Object[])new Object[]{fs, props});
            if (additionalArgs != null) {
                args.addAll(Lists.newArrayList((Object[])additionalArgs));
            }
            return (DatasetsFinder)GobblinConstructorUtils.invokeLongestConstructor(datasetFinderClass, (Object[])args.toArray());
        }
        catch (ReflectiveOperationException exception) {
            throw new IOException(exception);
        }
    }

    public static <T extends Dataset> IterableDatasetFinder<T> instantiateIterableDatasetFinder(Properties props, FileSystem fs, String default_class, Object ... additionalArgs) throws IOException {
        DatasetsFinder<T> datasetsFinder = DatasetUtils.instantiateDatasetFinder(props, fs, default_class, additionalArgs);
        return datasetsFinder instanceof IterableDatasetFinder ? (IterableDatasetFinder)datasetsFinder : new IterableDatasetFinderImpl(datasetsFinder);
    }

    public static PathFilter instantiatePathFilter(Properties props) {
        if (!props.containsKey(PATH_FILTER_KEY)) {
            return ACCEPT_ALL_PATH_FILTER;
        }
        try {
            Class<?> pathFilterClass = Class.forName(props.getProperty(PATH_FILTER_KEY));
            return (PathFilter)pathFilterClass.newInstance();
        }
        catch (ClassNotFoundException exception) {
            throw new RuntimeException(exception);
        }
        catch (InstantiationException exception) {
            throw new RuntimeException(exception);
        }
        catch (IllegalAccessException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static CopyableFileFilter instantiateCopyableFileFilter(Properties props, Object ... additionalArgs) {
        if (!props.containsKey(COPYABLE_FILE_FILTER_KEY)) {
            return ACCEPT_ALL_COPYABLE_FILE_FILTER;
        }
        try {
            Class<?> copyableFileFilterClass = Class.forName(props.getProperty(COPYABLE_FILE_FILTER_KEY));
            return (CopyableFileFilter)GobblinConstructorUtils.invokeLongestConstructor(copyableFileFilterClass, (Object[])additionalArgs);
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException(exception);
        }
    }
}

