/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.gobblin.data.management.copy.RecursiveCopyableDataset;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.testng.Assert;

public class TimeAwareRecursiveCopyableDataset
extends RecursiveCopyableDataset {
    private static final String CONFIG_PREFIX = "gobblin.copy.recursive";
    public static final String DATE_PATTERN_KEY = "gobblin.copy.recursive.date.pattern";
    public static final String LOOKBACK_TIME_KEY = "gobblin.copy.recursive.lookback.time";
    public static final String DEFAULT_DATE_PATTERN_TIMEZONE = "America/Los_Angeles";
    public static final String DATE_PATTERN_TIMEZONE_KEY = "gobblin.copy.recursive.datetime.timezone";
    private final String lookbackTime;
    private final String datePattern;
    private final Period lookbackPeriod;
    private final boolean isPatternHourly;
    private final LocalDateTime currentTime;

    public TimeAwareRecursiveCopyableDataset(FileSystem fs, Path rootPath, Properties properties, Path glob) {
        super(fs, rootPath, properties, glob);
        this.lookbackTime = properties.getProperty(LOOKBACK_TIME_KEY);
        PeriodFormatter periodFormatter = new PeriodFormatterBuilder().appendDays().appendSuffix("d").appendHours().appendSuffix("h").toFormatter();
        this.lookbackPeriod = periodFormatter.parsePeriod(this.lookbackTime);
        this.datePattern = properties.getProperty(DATE_PATTERN_KEY);
        this.isPatternHourly = this.isDatePatternHourly(this.datePattern);
        LocalDateTime localDateTime = this.currentTime = properties.containsKey(DATE_PATTERN_TIMEZONE_KEY) ? LocalDateTime.now((DateTimeZone)DateTimeZone.forID((String)DATE_PATTERN_TIMEZONE_KEY)) : LocalDateTime.now((DateTimeZone)DateTimeZone.forID((String)DEFAULT_DATE_PATTERN_TIMEZONE));
        if (!this.isPatternHourly) {
            Assert.assertTrue((boolean)this.isLookbackTimeStringDaily(this.lookbackTime), (String)"Expected day format for lookback time; found hourly format");
        }
    }

    private boolean isDatePatternHourly(String datePattern) {
        LocalDateTime refDateTimeAtStartOfDay;
        String refDateTimeStringAtStartOfDay;
        LocalDateTime refDateTime = new LocalDateTime(2017, 1, 1, 10, 0, 0);
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)datePattern);
        String refDateTimeString = refDateTime.toString(formatter);
        return !refDateTimeString.equals(refDateTimeStringAtStartOfDay = (refDateTimeAtStartOfDay = refDateTime.withHourOfDay(0)).toString(formatter));
    }

    private boolean isLookbackTimeStringDaily(String lookbackTime) {
        PeriodFormatter periodFormatter = new PeriodFormatterBuilder().appendDays().appendSuffix("d").toFormatter();
        try {
            periodFormatter.parsePeriod(lookbackTime);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    protected List<FileStatus> getFilesAtPath(FileSystem fs, Path path, PathFilter fileFilter) throws IOException {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)this.datePattern);
        LocalDateTime endDate = this.currentTime;
        LocalDateTime startDate = endDate.minus((ReadablePeriod)this.lookbackPeriod);
        DateRangeIterator dateRangeIterator = new DateRangeIterator(startDate, endDate, this.isPatternHourly);
        ArrayList fileStatuses = Lists.newArrayList();
        while (dateRangeIterator.hasNext()) {
            Path pathWithDateTime = new Path(path, dateRangeIterator.next().toString(formatter));
            fileStatuses.addAll(super.getFilesAtPath(fs, pathWithDateTime, fileFilter));
        }
        return fileStatuses;
    }

    public static class DateRangeIterator
    implements Iterator {
        private LocalDateTime startDate;
        private LocalDateTime endDate;
        private boolean isDatePatternHourly;

        public DateRangeIterator(LocalDateTime startDate, LocalDateTime endDate, boolean isDatePatternHourly) {
            this.startDate = startDate;
            this.endDate = endDate;
            this.isDatePatternHourly = isDatePatternHourly;
        }

        @Override
        public boolean hasNext() {
            return !this.startDate.isAfter((ReadablePartial)this.endDate);
        }

        public LocalDateTime next() {
            LocalDateTime dateTime = this.startDate;
            this.startDate = this.isDatePatternHourly ? this.startDate.plusHours(1) : this.startDate.plusDays(1);
            return dateTime;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

