/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.verify;

import com.google.common.annotations.VisibleForTesting;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import org.apache.gobblin.compaction.verify.CompactionAuditCountVerifier;
import org.apache.gobblin.compaction.verify.CompactionVerifier;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.dataset.FileSystemDataset;
import org.apache.gobblin.time.TimeIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionWatermarkChecker
extends CompactionAuditCountVerifier {
    private static final Logger log = LoggerFactory.getLogger(CompactionWatermarkChecker.class);
    public static final String TIME_FORMAT = "compactionWatermarkChecker.timeFormat";
    public static final String COMPACTION_WATERMARK = "compactionWatermark";
    public static final String COMPLETION_COMPACTION_WATERMARK = "completionAndCompactionWatermark";
    private final long watermarkTime;
    private final String precedingTimeDatasetPartitionName;

    public CompactionWatermarkChecker(State state) {
        super(state);
        ZonedDateTime compactionTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(state.getPropAsLong("compaction.init.time")), this.zone);
        ZonedDateTime precedingTime = TimeIterator.dec((ZonedDateTime)compactionTime, (TimeIterator.Granularity)this.granularity, (long)1L);
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern(state.getProp(TIME_FORMAT));
        this.precedingTimeDatasetPartitionName = timeFormatter.format(precedingTime);
        this.watermarkTime = CompactionWatermarkChecker.getWatermarkTimeMillis(compactionTime, this.granularity);
    }

    @VisibleForTesting
    static long getWatermarkTimeMillis(ZonedDateTime compactionTime, TimeIterator.Granularity granularity) {
        ZonedDateTime startOfMinute;
        ZonedDateTime startOfTimeGranularity = startOfMinute = compactionTime.withSecond(0).with(ChronoField.MILLI_OF_SECOND, 0L);
        switch (granularity) {
            case MINUTE: {
                break;
            }
            case HOUR: {
                startOfTimeGranularity = startOfMinute.withMinute(0);
                break;
            }
            case DAY: {
                startOfTimeGranularity = startOfMinute.withHour(0).withMinute(0);
                break;
            }
            case MONTH: {
                startOfTimeGranularity = startOfMinute.withDayOfMonth(1).withHour(0).withMinute(0);
            }
        }
        return startOfTimeGranularity.minus(1L, ChronoUnit.MILLIS).toInstant().toEpochMilli();
    }

    @Override
    public CompactionVerifier.Result verify(FileSystemDataset dataset) {
        CompactionVerifier.Result res = super.verify(dataset);
        if (!dataset.datasetRoot().toString().contains(this.precedingTimeDatasetPartitionName)) {
            return res;
        }
        this.state.setProp(COMPACTION_WATERMARK, (Object)this.watermarkTime);
        if (this.enabled && res.isSuccessful()) {
            log.info("Set dataset {} complete and compaction watermark {}", (Object)dataset.datasetRoot(), (Object)this.watermarkTime);
            this.state.setProp(COMPLETION_COMPACTION_WATERMARK, (Object)this.watermarkTime);
        } else {
            log.info("Set dataset {} compaction watermark {}", (Object)dataset.datasetRoot(), (Object)this.watermarkTime);
        }
        return res;
    }
}

