/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.mapreduce.test;

import org.apache.gobblin.compaction.source.CompactionSource;
import org.apache.gobblin.runtime.embedded.EmbeddedGobblin;
import org.apache.hadoop.fs.Path;

public class TestCompactionTaskUtils {
    public static final String PATH_SEPARATOR = "/";
    public static final String DEFAULT_INPUT_SUBDIR_TYPE = "minutely";

    public static EmbeddedGobblin createEmbeddedGobblinCompactionJob(String name, String basePath) {
        return TestCompactionTaskUtils.createEmbeddedGobblinCompactionJob(name, basePath, DEFAULT_INPUT_SUBDIR_TYPE);
    }

    public static EmbeddedGobblin createEmbeddedGobblinCompactionJob(String name, String basePath, String inputSubdirType) {
        String outputSubdirType;
        String pattern;
        if (inputSubdirType.equals(DEFAULT_INPUT_SUBDIR_TYPE)) {
            pattern = new Path(basePath, "*/*/minutely/*/*/*/*").toString();
            outputSubdirType = "hourly";
        } else {
            pattern = new Path(basePath, "*/*/hourly/*/*/*").toString();
            outputSubdirType = "daily";
        }
        return new EmbeddedGobblin(name).setConfiguration("source.class", CompactionSource.class.getName()).setConfiguration("gobblin.dataset.pattern", pattern).setConfiguration("compaction.input.dir", basePath).setConfiguration("compaction.input.subdir", inputSubdirType).setConfiguration("compaction.dest.dir", basePath).setConfiguration("compaction.dest.subdir", outputSubdirType).setConfiguration("compaction.tmp.dest.dir", "/tmp/compaction/" + name).setConfiguration("compaction.timebased.max.time.ago", "3000d").setConfiguration("compaction.timebased.min.time.ago", "1d").setConfiguration("task.maxretries", "0");
    }
}

