/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.mapreduce.orc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.gobblin.compaction.mapreduce.RecordKeyDedupReducerBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.orc.mapred.OrcKey;
import org.apache.orc.mapred.OrcStruct;
import org.apache.orc.mapred.OrcValue;

public class OrcKeyDedupReducer
extends RecordKeyDedupReducerBase<OrcKey, OrcValue, NullWritable, OrcValue> {
    @VisibleForTesting
    public static final String ORC_DELTA_SCHEMA_PROVIDER = "org.apache.gobblin.compaction." + OrcKeyDedupReducer.class.getSimpleName() + ".deltaFieldsProvider";
    public static final String USING_WHOLE_RECORD_FOR_COMPARE = "usingWholeRecordForCompareInReducer";

    @Override
    protected void setOutValue(OrcValue valueToRetain) {
        ((OrcValue)this.outValue).value = valueToRetain.value;
    }

    @Override
    protected void setOutKey(OrcValue valueToRetain) {
    }

    @Override
    protected void reduce(OrcKey key, Iterable<OrcValue> values, Reducer.Context context) throws IOException, InterruptedException {
        HashMap<Integer, Integer> valuesToRetain = new HashMap<Integer, Integer>();
        int valueHash = 0;
        for (OrcValue orcValue : values) {
            valueHash = ((OrcStruct)orcValue.value).hashCode();
            if (valuesToRetain.containsKey(valueHash)) {
                valuesToRetain.put(valueHash, (Integer)valuesToRetain.get(valueHash) + 1);
                continue;
            }
            valuesToRetain.put(valueHash, 1);
            this.writeRetainedValue(orcValue, context);
        }
        for (Map.Entry entry : valuesToRetain.entrySet()) {
            this.updateCounters((Integer)entry.getValue(), context);
        }
    }

    @Override
    protected void initDeltaComparator(Configuration conf) {
        this.deltaComparatorOptional = Optional.absent();
    }

    @Override
    protected void initReusableObject() {
        this.outKey = NullWritable.get();
        this.outValue = new OrcValue();
    }
}

