/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.suite;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.gobblin.compaction.action.CompactionCompleteAction;
import org.apache.gobblin.compaction.suite.CompactionSuiteBase;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.dataset.FileSystemDataset;
import org.apache.gobblin.util.reflection.GobblinConstructorUtils;

public class CompactionSuiteBaseWithConfigurableCompleteAction
extends CompactionSuiteBase {
    private static final String COMPACTION_COMPLETE_ACTIONS = "compaction.complete.actions";

    public CompactionSuiteBaseWithConfigurableCompleteAction(State state) {
        super(state);
    }

    @Override
    public List<CompactionCompleteAction<FileSystemDataset>> getCompactionCompleteActions() throws IOException {
        Preconditions.checkArgument((boolean)this.state.contains(COMPACTION_COMPLETE_ACTIONS));
        ArrayList<CompactionCompleteAction<FileSystemDataset>> compactionCompleteActionsList = new ArrayList<CompactionCompleteAction<FileSystemDataset>>();
        try {
            for (String s : this.state.getPropAsList(COMPACTION_COMPLETE_ACTIONS)) {
                compactionCompleteActionsList.add((CompactionCompleteAction)GobblinConstructorUtils.invokeLongestConstructor(Class.forName(s), (Object[])new Object[]{this.state, this.getConfigurator()}));
            }
        }
        catch (ReflectiveOperationException e) {
            throw new IOException(e);
        }
        return compactionCompleteActionsList;
    }
}

