/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.mapreduce.orc;

import java.io.DataInput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.RawComparator;
import org.apache.orc.OrcConf;
import org.apache.orc.TypeDescription;
import org.apache.orc.mapred.OrcKey;
import org.apache.orc.mapred.OrcStruct;

public class OrcKeyComparator
extends Configured
implements RawComparator<OrcKey> {
    private TypeDescription schema;
    private OrcKey key1;
    private OrcKey key2;
    private DataInputBuffer buffer;

    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (null != conf) {
            this.schema = TypeDescription.fromString((String)conf.get(OrcConf.MAPRED_SHUFFLE_KEY_SCHEMA.getAttribute()));
            OrcStruct orcRecordModel1 = (OrcStruct)OrcStruct.createValue((TypeDescription)this.schema);
            OrcStruct orcRecordModel2 = (OrcStruct)OrcStruct.createValue((TypeDescription)this.schema);
            if (this.key1 == null) {
                this.key1 = new OrcKey();
            }
            if (this.key2 == null) {
                this.key2 = new OrcKey();
            }
            if (this.buffer == null) {
                this.buffer = new DataInputBuffer();
            }
            this.key1.key = orcRecordModel1;
            this.key2.key = orcRecordModel2;
        }
    }

    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        try {
            this.buffer.reset(b1, s1, l1);
            this.key1.readFields((DataInput)this.buffer);
            this.buffer.reset(b2, s2, l2);
            this.key2.readFields((DataInput)this.buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.compare(this.key1, this.key2);
    }

    public int compare(OrcKey o1, OrcKey o2) {
        if (!(o1.key instanceof OrcStruct) || !(o2.key instanceof OrcStruct)) {
            throw new IllegalStateException("OrcKey should have its key value be instance of OrcStruct");
        }
        return ((OrcStruct)o1.key).compareTo((OrcStruct)o2.key);
    }
}

