/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.mapreduce;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.util.VersionInfo;

public abstract class CompactionCombineFileInputFormat<KI, KO>
extends CombineFileInputFormat<KI, KO> {
    private static final String COMPACTION_JOB_PREFIX = "compaction.job.";
    private static final String COMPACTION_JOB_MAPRED_MAX_SPLIT_SIZE = "compaction.job.mapred.max.split.size";
    private static final long DEFAULT_COMPACTION_JOB_MAPRED_MAX_SPLIT_SIZE = 0x10000000L;
    private static final String COMPACTION_JOB_MAPRED_MIN_SPLIT_SIZE = "compaction.job.mapred.min.split.size";
    private static final long DEFAULT_COMPACTION_JOB_MAPRED_MIN_SPLIT_SIZE = 0x10000000L;
    private static final int SPLIT_MAX_NUM_LOCATIONS = 10;

    public List<InputSplit> getSplits(JobContext cx) throws IOException {
        Job modifiedJob = Job.getInstance((Configuration)cx.getConfiguration());
        this.setSplitSize((JobContext)modifiedJob);
        FileInputFormat.setInputDirRecursive((Job)modifiedJob, (boolean)true);
        return CompactionCombineFileInputFormat.cleanSplits(super.getSplits((JobContext)modifiedJob));
    }

    private void setSplitSize(JobContext cx) {
        super.setMaxSplitSize(cx.getConfiguration().getLong(COMPACTION_JOB_MAPRED_MAX_SPLIT_SIZE, 0x10000000L));
        super.setMinSplitSizeNode(cx.getConfiguration().getLong(COMPACTION_JOB_MAPRED_MIN_SPLIT_SIZE, 0x10000000L));
    }

    private static List<InputSplit> cleanSplits(List<InputSplit> splits) throws IOException {
        if (VersionInfo.getVersion().compareTo("2.3.0") >= 0) {
            return splits;
        }
        ArrayList cleanedSplits = Lists.newArrayList();
        for (int i = 0; i < splits.size(); ++i) {
            CombineFileSplit oldSplit = (CombineFileSplit)splits.get(i);
            String[] locations = oldSplit.getLocations();
            Preconditions.checkNotNull((Object)locations, (Object)"CombineFileSplit.getLocations() returned null");
            if (locations.length > 10) {
                locations = Arrays.copyOf(locations, 10);
            }
            cleanedSplits.add(new CombineFileSplit(oldSplit.getPaths(), oldSplit.getStartOffsets(), oldSplit.getLengths(), locations));
        }
        return cleanedSplits;
    }
}

