/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.audit;

import com.google.api.client.util.Charsets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.gobblin.compaction.audit.AuditCountClient;
import org.apache.gobblin.configuration.State;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class PinotAuditCountHttpClient
implements AuditCountClient {
    private static final Logger log = LoggerFactory.getLogger(PinotAuditCountHttpClient.class);
    public static final String PINOT_AUDIT_HTTP = "pinot.audit.http";
    public static final String CONNECTION_MAX_TOTAL = "pinot.audit.httpmax.total";
    public static final int DEFAULT_CONNECTION_MAX_TOTAL = 10;
    public static final String MAX_PER_ROUTE = "pinot.audit.httpmax.per.route";
    public static final int DEFAULT_MAX_PER_ROUTE = 10;
    public static final String TARGET_HOST = "pinot.audit.httptarget.host";
    public static final String TARGET_PORT = "pinot.audit.httptarget.port";
    private PoolingHttpClientConnectionManager cm;
    private CloseableHttpClient httpClient;
    private static final JsonParser PARSER = new JsonParser();
    private String targetUrl;

    public PinotAuditCountHttpClient(State state) {
        int maxTotal = state.getPropAsInt(CONNECTION_MAX_TOTAL, 10);
        int maxPerRoute = state.getPropAsInt(MAX_PER_ROUTE, 10);
        this.cm = new PoolingHttpClientConnectionManager();
        this.cm.setMaxTotal(maxTotal);
        this.cm.setDefaultMaxPerRoute(maxPerRoute);
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.cm).build();
        String host = state.getProp(TARGET_HOST);
        int port = state.getPropAsInt(TARGET_PORT);
        this.targetUrl = host + ":" + port + "/pql?pql=";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Long> fetch(String datasetName, long start, long end) throws IOException {
        JsonObject all;
        JsonArray aggregationResults;
        String rst;
        HashMap<String, Long> map;
        block8: {
            map = new HashMap<String, Long>();
            String query = "select tier, sum(count) from kafkaAudit where eventType=\"" + datasetName + "\" and " + "beginTimestamp >= \"" + start + "\" and " + "beginTimestamp < \"" + end + "\" group by tier";
            String fullURL = this.targetUrl + URLEncoder.encode(query, Charsets.UTF_8.toString());
            HttpGet req = new HttpGet(fullURL);
            rst = null;
            HttpEntity entity = null;
            log.info("Full url for {} is {}", (Object)datasetName, (Object)fullURL);
            try {
                CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)req, (HttpContext)HttpClientContext.create());
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode < 200 || statusCode >= 300) {
                    throw new IOException(String.format("status code: %d, reason: %s", statusCode, response.getStatusLine().getReasonPhrase()));
                }
                entity = response.getEntity();
                rst = EntityUtils.toString((HttpEntity)entity);
                if (entity == null) break block8;
            }
            catch (Throwable throwable) {
                if (entity != null) {
                    EntityUtils.consume(entity);
                }
                throw throwable;
            }
            EntityUtils.consume((HttpEntity)entity);
        }
        if ((aggregationResults = (all = PARSER.parse(rst).getAsJsonObject()).getAsJsonArray("aggregationResults")) == null || aggregationResults.size() == 0) {
            log.error(all.toString());
            throw new IOException("No aggregation results " + all.toString());
        }
        JsonObject aggregation = (JsonObject)aggregationResults.get(0);
        JsonArray groupByResult = aggregation.getAsJsonArray("groupByResult");
        if (groupByResult == null || groupByResult.size() == 0) {
            log.error(aggregation.toString());
            throw new IOException("No aggregation results " + aggregation.toString());
        }
        log.info("Audit count for {} is {}", (Object)datasetName, (Object)groupByResult);
        Iterator iterator = groupByResult.iterator();
        while (iterator.hasNext()) {
            JsonElement ele = (JsonElement)iterator.next();
            JsonObject record = (JsonObject)ele;
            map.put(record.getAsJsonArray("group").get(0).getAsString(), (long)Double.parseDouble(record.get("value").getAsString()));
        }
        return map;
    }
}

