/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.publisher;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Map;
import org.apache.gobblin.capability.Capability;
import org.apache.gobblin.capability.CapabilityAware;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;

public abstract class DataPublisher
implements Closeable,
CapabilityAware {
    public static final Capability REUSABLE = new Capability("REUSABLE", false);
    protected final State state;

    public DataPublisher(State state) {
        this.state = state;
    }

    @Deprecated
    public abstract void initialize() throws IOException;

    public abstract void publishData(Collection<? extends WorkUnitState> var1) throws IOException;

    public abstract void publishMetadata(Collection<? extends WorkUnitState> var1) throws IOException;

    public void publish(Collection<? extends WorkUnitState> states) throws IOException {
        if (this.shouldPublishMetadataFirst()) {
            this.publishMetadata(states);
            this.publishData(states);
        } else {
            this.publishData(states);
            this.publishMetadata(states);
        }
        this.markCommit(states);
    }

    protected void markCommit(Collection<? extends WorkUnitState> states) {
        for (WorkUnitState workUnitState : states) {
            if (workUnitState.getWorkingState() != WorkUnitState.WorkingState.SUCCESSFUL) continue;
            workUnitState.setWorkingState(WorkUnitState.WorkingState.COMMITTED);
        }
    }

    public State getState() {
        return this.state;
    }

    public static DataPublisher getInstance(Class<? extends DataPublisher> dataPublisherClass, State state) throws ReflectiveOperationException {
        Constructor<? extends DataPublisher> dataPublisherConstructor = dataPublisherClass.getConstructor(State.class);
        return dataPublisherConstructor.newInstance(state);
    }

    public boolean isThreadSafe() {
        return this.getClass() == DataPublisher.class;
    }

    public boolean canBeSkipped() {
        return this.state.getPropAsBoolean("data.publisher.canBeSkipped", false);
    }

    protected boolean shouldPublishMetadataFirst() {
        return true;
    }

    @Override
    public boolean supportsCapability(Capability c, Map<String, Object> properties) {
        return false;
    }
}

