/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.dataset;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.gobblin.dataset.Descriptor;

public class DatasetDescriptor
extends Descriptor {
    private static final String PLATFORM_KEY = "platform";
    private static final String NAME_KEY = "name";
    private static final String STORAGE_URL = "storageUrl";
    private final String platform;
    @Nullable
    private final URI storageUrl;
    private final Map<String, String> metadata = Maps.newHashMap();

    @Deprecated
    public DatasetDescriptor(String platform, String name) {
        super(name);
        this.storageUrl = null;
        this.platform = platform;
    }

    public DatasetDescriptor(String platform, URI storageUrl, String name) {
        super(name);
        this.storageUrl = storageUrl;
        this.platform = platform;
    }

    @Deprecated
    public DatasetDescriptor(DatasetDescriptor copy) {
        super(copy.getName());
        this.platform = copy.getPlatform();
        this.storageUrl = copy.getStorageUrl();
        this.metadata.putAll((Map<String, String>)copy.getMetadata());
    }

    @Deprecated
    public static DatasetDescriptor fromDataMap(Map<String, String> dataMap) {
        String storageUrlString = dataMap.getOrDefault(STORAGE_URL, null);
        URI storageUrl = null;
        if (storageUrlString != null) {
            storageUrl = URI.create(storageUrlString);
        }
        DatasetDescriptor descriptor = new DatasetDescriptor(dataMap.get(PLATFORM_KEY), storageUrl, dataMap.get(NAME_KEY));
        dataMap.forEach((key, value) -> {
            if (!(key.equals(PLATFORM_KEY) || key.equals(NAME_KEY) || key.equals(STORAGE_URL))) {
                descriptor.addMetadata((String)key, (String)value);
            }
        });
        return descriptor;
    }

    public ImmutableMap<String, String> getMetadata() {
        return ImmutableMap.builder().putAll(this.metadata).build();
    }

    @Override
    public DatasetDescriptor copy() {
        return new DatasetDescriptor(this);
    }

    public void addMetadata(String key, String value) {
        this.metadata.put(key, value);
    }

    @Deprecated
    public Map<String, String> toDataMap() {
        HashMap map = Maps.newHashMap();
        map.put(PLATFORM_KEY, this.platform);
        map.put(NAME_KEY, this.getName());
        if (this.getStorageUrl() != null) {
            map.put(STORAGE_URL, this.getStorageUrl().toString());
        }
        map.putAll(this.metadata);
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatasetDescriptor that = (DatasetDescriptor)o;
        return this.platform.equals(that.platform) && Objects.equals(this.storageUrl, that.storageUrl) && this.metadata.equals(that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.platform, this.storageUrl, this.metadata);
    }

    public String getPlatform() {
        return this.platform;
    }

    @Nullable
    public URI getStorageUrl() {
        return this.storageUrl;
    }
}

