/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.stream;

import javax.annotation.Nullable;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.fork.CopyHelper;
import org.apache.gobblin.fork.CopyNotSupportedException;
import org.apache.gobblin.source.extractor.CheckpointableWatermark;
import org.apache.gobblin.stream.StreamEntity;

@Alpha
public class RecordEnvelope<D>
extends StreamEntity<D> {
    private final D _record;
    @Nullable
    private final CheckpointableWatermark _watermark;

    public RecordEnvelope(D record) {
        this(record, null);
    }

    private RecordEnvelope(D record, RecordEnvelope<?> parentRecord, boolean copyCallbacks) {
        super(parentRecord, copyCallbacks);
        this._record = record;
        this._watermark = parentRecord._watermark;
    }

    private RecordEnvelope(D record, ForkRecordBuilder<D> forkRecordBuilder, boolean copyCallbacks) {
        super(forkRecordBuilder, copyCallbacks);
        this._record = record;
        this._watermark = forkRecordBuilder.getRecordEnvelope()._watermark;
    }

    public RecordEnvelope(D record, CheckpointableWatermark watermark) {
        if (record instanceof RecordEnvelope) {
            throw new IllegalStateException("Cannot wrap a RecordEnvelope in another RecordEnvelope.");
        }
        this._record = record;
        this._watermark = watermark;
    }

    public <DO> RecordEnvelope<DO> withRecord(DO newRecord) {
        return new RecordEnvelope<DO>(newRecord, this, true);
    }

    public D getRecord() {
        return this._record;
    }

    @Nullable
    public CheckpointableWatermark getWatermark() {
        return this._watermark;
    }

    @Override
    protected StreamEntity<D> buildClone() {
        try {
            return new RecordEnvelope<Object>(CopyHelper.copy(this._record), this, false);
        }
        catch (CopyNotSupportedException cnse) {
            throw new UnsupportedOperationException(cnse);
        }
    }

    public <DO> ForkRecordBuilder<DO> forkRecordBuilder() {
        return new ForkRecordBuilder();
    }

    public class ForkRecordBuilder<DO>
    extends StreamEntity.ForkedEntityBuilder {
        private ForkRecordBuilder() {
        }

        public RecordEnvelope<DO> childRecord(DO newRecord) {
            return new RecordEnvelope(newRecord, this, true);
        }

        RecordEnvelope<D> getRecordEnvelope() {
            return RecordEnvelope.this;
        }
    }
}

