/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.dataset;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.gobblin.dataset.Descriptor;

public class DatasetDescriptor
extends Descriptor {
    private static final String PLATFORM_KEY = "platform";
    private static final String NAME_KEY = "name";
    private final String platform;
    private final Map<String, String> metadata = Maps.newHashMap();

    public DatasetDescriptor(String platform, String name) {
        super(name);
        this.platform = platform;
    }

    @Deprecated
    public DatasetDescriptor(DatasetDescriptor copy) {
        super(copy.getName());
        this.platform = copy.getPlatform();
        this.metadata.putAll((Map<String, String>)copy.getMetadata());
    }

    public ImmutableMap<String, String> getMetadata() {
        return ImmutableMap.builder().putAll(this.metadata).build();
    }

    @Override
    public DatasetDescriptor copy() {
        return new DatasetDescriptor(this);
    }

    public void addMetadata(String key, String value) {
        this.metadata.put(key, value);
    }

    @Deprecated
    public Map<String, String> toDataMap() {
        HashMap map = Maps.newHashMap();
        map.put(PLATFORM_KEY, this.platform);
        map.put(NAME_KEY, this.getName());
        map.putAll(this.metadata);
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatasetDescriptor that = (DatasetDescriptor)o;
        return this.platform.equals(that.platform) && this.getName().equals(that.getName()) && this.metadata.equals(that.metadata);
    }

    public int hashCode() {
        int result = this.platform.hashCode();
        result = 31 * result + this.getName().hashCode();
        result = 31 * result + this.metadata.hashCode();
        return result;
    }

    @Deprecated
    public static DatasetDescriptor fromDataMap(Map<String, String> dataMap) {
        DatasetDescriptor descriptor = new DatasetDescriptor(dataMap.get(PLATFORM_KEY), dataMap.get(NAME_KEY));
        dataMap.forEach((key, value) -> {
            if (!key.equals(PLATFORM_KEY) && !key.equals(NAME_KEY)) {
                descriptor.addMetadata((String)key, (String)value);
            }
        });
        return descriptor;
    }

    public String getPlatform() {
        return this.platform;
    }
}

