/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.dataset;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.dataset.DatasetDescriptor;
import org.apache.gobblin.dataset.DatasetResolver;

public class HiveToHdfsDatasetResolver
implements DatasetResolver {
    public static final String HIVE_TABLE = "hiveTable";
    public static final HiveToHdfsDatasetResolver INSTANCE = new HiveToHdfsDatasetResolver();

    private HiveToHdfsDatasetResolver() {
    }

    @Override
    public DatasetDescriptor resolve(DatasetDescriptor raw, State state) {
        ImmutableMap<String, String> metadata = raw.getMetadata();
        Preconditions.checkArgument((boolean)metadata.containsKey((Object)"fsScheme"), (Object)String.format("Hive Dataset Descriptor must contain metadata %s to create Hdfs Dataset Descriptor", "fsScheme"));
        Preconditions.checkArgument((boolean)metadata.containsKey((Object)"fsScheme"), (Object)String.format("Hive Dataset Descriptor must contain metadata %s to create Hdfs Dataset Descriptor", "fsLocation"));
        DatasetDescriptor datasetDescriptor = new DatasetDescriptor((String)metadata.get((Object)"fsScheme"), (String)metadata.get((Object)"fsLocation"));
        datasetDescriptor.addMetadata(HIVE_TABLE, raw.getName());
        return datasetDescriptor;
    }
}

