/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.pluto;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.driver.config.AdminConfiguration;
import org.apache.pluto.driver.config.DriverConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalStartupListener
implements ServletContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(PortalStartupListener.class);
    private static final String CONTAINER_KEY = "portletContainer";
    private static final String DRIVER_CONFIG_KEY = "driverConfig";
    private static final String ADMIN_CONFIG_KEY = "driverAdminConfig";

    public void contextInitialized(ServletContextEvent event) {
        LOG.info("Starting up Pluto Portal Driver. . .");
        ServletContext servletContext = event.getServletContext();
        BundleContext bundleContext = (BundleContext)servletContext.getAttribute("osgi-bundlecontext");
        LOG.debug(" [1a] Loading DriverConfiguration. . . ");
        ServiceReference serviceReference = bundleContext.getServiceReference(DriverConfiguration.class.getName());
        DriverConfiguration driverConfiguration = (DriverConfiguration)bundleContext.getService(serviceReference);
        LOG.debug(" [1b] Registering DriverConfiguration. . .");
        servletContext.setAttribute(DRIVER_CONFIG_KEY, (Object)driverConfiguration);
        LOG.debug(" [2a] Loading Optional AdminConfiguration. . .");
        serviceReference = bundleContext.getServiceReference(AdminConfiguration.class.getName());
        AdminConfiguration adminConfiguration = (AdminConfiguration)bundleContext.getService(serviceReference);
        if (adminConfiguration != null) {
            LOG.debug(" [2b] Registering Optional AdminConfiguration");
            servletContext.setAttribute(ADMIN_CONFIG_KEY, (Object)adminConfiguration);
        } else {
            LOG.info("Optional AdminConfiguration not found. Ignoring.");
        }
        DriverConfiguration driverConfig = (DriverConfiguration)servletContext.getAttribute(DRIVER_CONFIG_KEY);
        LOG.info("Initializing Portlet Container. . .");
        LOG.debug(" [1] Creating portlet container...");
        serviceReference = bundleContext.getServiceReference(PortletContainer.class.getName());
        PortletContainer container = (PortletContainer)bundleContext.getService(serviceReference);
        servletContext.setAttribute(CONTAINER_KEY, (Object)container);
        LOG.info("Pluto portlet container started.");
        LOG.info("********** Pluto Portal Driver Started **********\n\n");
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        if (LOG.isInfoEnabled()) {
            LOG.info("Shutting down Pluto Portal Driver...");
        }
        this.destroyContainer(servletContext);
        this.destroyAdminConfiguration(servletContext);
        this.destroyDriverConfiguration(servletContext);
        if (LOG.isInfoEnabled()) {
            LOG.info("********** Pluto Portal Driver Shut Down **********\n\n");
        }
    }

    private void destroyContainer(ServletContext servletContext) {
        PortletContainer container;
        if (LOG.isInfoEnabled()) {
            LOG.info("Shutting down Pluto Portal Driver...");
        }
        if ((container = (PortletContainer)servletContext.getAttribute(CONTAINER_KEY)) != null) {
            servletContext.removeAttribute(CONTAINER_KEY);
        }
    }

    private void destroyDriverConfiguration(ServletContext servletContext) {
        DriverConfiguration driverConfig = (DriverConfiguration)servletContext.getAttribute(DRIVER_CONFIG_KEY);
        if (driverConfig != null) {
            servletContext.removeAttribute(DRIVER_CONFIG_KEY);
        }
    }

    private void destroyAdminConfiguration(ServletContext servletContext) {
        AdminConfiguration adminConfig = (AdminConfiguration)servletContext.getAttribute(ADMIN_CONFIG_KEY);
        if (adminConfig != null) {
            servletContext.removeAttribute(ADMIN_CONFIG_KEY);
        }
    }
}

