/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.pluto;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelRegistry;
import org.apache.geronimo.pluto.PortalContainerServices;
import org.apache.pluto.driver.config.AdminConfiguration;
import org.apache.pluto.driver.config.DriverConfiguration;
import org.apache.pluto.driver.services.portal.PropertyConfigService;
import org.apache.pluto.driver.services.portal.RenderConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalContainerServicesGBean
implements PortalContainerServices,
GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(PortalContainerServicesGBean.class);
    private RenderConfigService renderConfigService;
    private PropertyConfigService propertyConfigService;
    private DriverConfiguration driverConfiguration;
    private AdminConfiguration adminConfiguration;
    private CountDownLatch latch = new CountDownLatch(1);
    public static final GBeanInfo GBEAN_INFO;

    public void doStart() throws Exception {
        log.debug("Started PortalContainerServicesGBean");
    }

    public void doStop() throws Exception {
        log.debug("Stopped PortalContainerServicesGBean");
    }

    public void doFail() {
        log.warn("PortalContainerServicesGBean Failed");
    }

    @Override
    public AdminConfiguration getAdminConfiguration() {
        return this.adminConfiguration;
    }

    @Override
    public void setAdminConfiguration(AdminConfiguration adminConfiguration) {
        this.adminConfiguration = adminConfiguration;
    }

    @Override
    public RenderConfigService getRenderConfigService() {
        return this.renderConfigService;
    }

    @Override
    public void setRenderConfigService(RenderConfigService renderConfigService) {
        this.renderConfigService = renderConfigService;
    }

    @Override
    public DriverConfiguration getDriverConfiguration() {
        return this.driverConfiguration;
    }

    @Override
    public void setDriverConfiguration(DriverConfiguration driverConfigurion) {
        this.driverConfiguration = driverConfigurion;
    }

    @Override
    public PropertyConfigService getPropertyConfigService() {
        return this.propertyConfigService;
    }

    @Override
    public void setPropertyConfigService(PropertyConfigService propertyConfigService) {
        this.propertyConfigService = propertyConfigService;
    }

    public static PortalContainerServices getSingleton() {
        Kernel kernel = KernelRegistry.getSingleKernel();
        PortalContainerServices portalServices = null;
        try {
            portalServices = (PortalContainerServices)kernel.getGBean(PortalContainerServices.class);
        }
        catch (Exception e) {
            log.error("Failed to get PortalContainerServices GBean from kernel", (Throwable)e);
        }
        return portalServices;
    }

    public void init() {
        this.latch.countDown();
    }

    @Override
    public boolean waitForInitialization(int timeout) throws InterruptedException {
        return this.latch.await(timeout, TimeUnit.MILLISECONDS);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"PortalContainerServicesGBean", PortalContainerServicesGBean.class);
        infoFactory.addInterface(PortalContainerServices.class);
        infoFactory.setConstructor(new String[0]);
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

