/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.yoko;

import java.net.Socket;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.geronimo.corba.security.SSLSessionManager;
import org.apache.yoko.orb.OCI.IIOP.TransportInfo_impl;
import org.apache.yoko.orb.PortableInterceptor.ServerRequestInfoExt;
import org.omg.CORBA.LocalObject;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ServiceContextInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    private final Logger log = LoggerFactory.getLogger(ServiceContextInterceptor.class);

    public ServiceContextInterceptor() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("<init>");
        }
    }

    public void receive_request(ServerRequestInfo ri) {
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) {
        Socket socket;
        ServerRequestInfoExt riExt;
        TransportInfo_impl connection;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Looking for SSL Session");
        }
        if ((connection = (TransportInfo_impl)(riExt = (ServerRequestInfoExt)ri).getTransportInfo()) != null && (socket = connection.socket()) != null && socket instanceof SSLSocket) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Found SSL Session");
            }
            SSLSocket sslSocket = (SSLSocket)socket;
            SSLSessionManager.setSSLSession((int)ri.request_id(), (SSLSession)sslSocket.getSession());
        }
    }

    public void send_exception(ServerRequestInfo ri) {
        SSLSession old = SSLSessionManager.clearSSLSession((int)ri.request_id());
        if (this.log.isDebugEnabled() && old != null) {
            this.log.debug("Removing SSL Session for send_exception");
        }
    }

    public void send_other(ServerRequestInfo ri) {
        SSLSession old = SSLSessionManager.clearSSLSession((int)ri.request_id());
        if (this.log.isDebugEnabled() && old != null) {
            this.log.debug("Removing SSL Session for send_reply");
        }
    }

    public void send_reply(ServerRequestInfo ri) {
        SSLSession old = SSLSessionManager.clearSSLSession((int)ri.request_id());
        if (this.log.isDebugEnabled() && old != null) {
            this.log.debug("Removing SSL Session for send_reply");
        }
    }

    public void destroy() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Destroy");
        }
    }

    public String name() {
        return "org.apache.geronimo.yoko.ServiceContextInterceptor";
    }
}

