/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.yoko;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.geronimo.corba.CORBABean;
import org.apache.geronimo.corba.CSSBean;
import org.apache.geronimo.corba.NameService;
import org.apache.geronimo.corba.ORBConfiguration;
import org.apache.geronimo.corba.security.config.ConfigAdapter;
import org.apache.geronimo.corba.security.config.ConfigException;
import org.apache.geronimo.corba.security.config.tss.TSSConfig;
import org.apache.geronimo.corba.security.config.tss.TSSSSLTransportConfig;
import org.apache.geronimo.corba.security.config.tss.TSSTransportMechConfig;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.yoko.orb.CosNaming.tnaming.TransientNameService;
import org.apache.yoko.orb.CosNaming.tnaming.TransientServiceException;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean(j2eeType="ORBConfig")
public class ORBConfigAdapter
implements ConfigAdapter {
    private final Logger log = LoggerFactory.getLogger(ORBConfigAdapter.class);

    public ORBConfigAdapter(@ParamSpecial(type=SpecialAttributeType.bundle) Bundle bundle) throws Exception {
        this.log.debug("Started  Yoko ORBConfigAdapter");
    }

    public ORB createServerORB(CORBABean server) throws ConfigException {
        ORB orb = this.createORB(server.getURI(), (ORBConfiguration)server, this.translateToArgs(server), this.translateToProps(server));
        TSSConfig config = server.getTssConfig();
        TSSTransportMechConfig transportMech = config.getTransport_mech();
        if (transportMech != null && transportMech instanceof TSSSSLTransportConfig) {
            Any any = orb.create_any();
            any.insert_boolean(true);
            try {
                Policy portPolicy = orb.create_policy(1330577419, any);
                Policy[] overrides = new Policy[]{portPolicy};
                server.setPolicyOverrides(overrides);
            }
            catch (PolicyError e) {
                // empty catch block
            }
        }
        return orb;
    }

    public ORB createClientORB(CSSBean client) throws ConfigException {
        return this.createORB(client.getURI(), (ORBConfiguration)client, this.translateToArgs(client), this.translateToProps(client));
    }

    public ORB createNameServiceClientORB(CSSBean client) throws ConfigException {
        return this.createORB(client.getURI(), (ORBConfiguration)client, this.translateToArgs(client), this.translateToNameServiceProps(client));
    }

    public Object createNameService(String host, int port, final int servicePort) throws ConfigException {
        try {
            TransientNameService service = new TransientNameService(host, port, "NameService"){

                public void run() throws TransientServiceException {
                    Properties props = new Properties();
                    props.putAll((Map<?, ?>)System.getProperties());
                    props.put("org.omg.CORBA.ORBServerId", "1000000");
                    props.put("org.omg.CORBA.ORBClass", "org.apache.yoko.orb.CORBA.ORB");
                    props.put("org.omg.CORBA.ORBSingletonClass", "org.apache.yoko.orb.CORBA.ORBSingleton");
                    props.put("yoko.orb.oa.endpoint", "iiop --bind " + this.host + " --host " + this.host + " --port " + this.port);
                    String nameServiceEndpoint = "iiop --bind " + this.host + " --host " + this.host;
                    if (servicePort > 0) {
                        nameServiceEndpoint = nameServiceEndpoint + " --port " + servicePort;
                    }
                    props.put("yoko.orb.poamanager.TNameService.endpoint", nameServiceEndpoint);
                    this.createdOrb = ORB.init((String[])null, (Properties)props);
                    this.initialize(this.createdOrb);
                }
            };
            service.run();
            this.log.debug("Creating ORB endpoint with host=" + host + ", port=" + port);
            return service;
        }
        catch (TransientServiceException e) {
            throw new ConfigException("Error starting transient name service on port " + port, (Throwable)e);
        }
    }

    public void destroyNameService(Object ns) {
        ((TransientNameService)ns).destroy();
    }

    private ORB createORB(String name, ORBConfiguration config, String[] args, Properties props) {
        return ORB.init((String[])args, (Properties)props);
    }

    private String[] translateToArgs(CORBABean server) throws ConfigException {
        ArrayList<String> list = new ArrayList<String>();
        this.enableSocketFactory(server.getURI(), list);
        NameService nameService = server.getNameService();
        if (nameService != null) {
            list.add("-ORBInitRef");
            list.add("NameService=" + nameService.getURI());
        }
        if (this.log.isDebugEnabled()) {
            for (String configArg : list) {
                this.log.debug(configArg);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private Properties translateToProps(CORBABean server) throws ConfigException {
        Properties result = new Properties();
        result.put("org.omg.CORBA.ORBClass", "org.apache.yoko.orb.CORBA.ORB");
        result.put("org.omg.CORBA.ORBSingletonClass", "org.apache.yoko.orb.CORBA.ORBSingleton");
        result.put("org.omg.PortableInterceptor.ORBInitializerClass.org.apache.geronimo.corba.transaction.TransactionInitializer", "");
        result.put("org.omg.PortableInterceptor.ORBInitializerClass.org.apache.geronimo.corba.security.SecurityInitializer", "");
        result.put("org.omg.PortableInterceptor.ORBInitializerClass.org.apache.geronimo.yoko.ORBInitializer", "");
        if (server.getPort() > 0) {
            result.put("yoko.orb.oa.endpoint", "iiop --bind " + server.getHost() + " --host " + server.getHost() + " --port " + server.getPort());
        } else {
            result.put("yoko.orb.oa.endpoint", "iiop --bind " + server.getHost() + " --host " + server.getHost());
        }
        result.put("yoko.orb.id", server.getURI());
        TSSConfig config = server.getTssConfig();
        TSSTransportMechConfig transportMech = config.getTransport_mech();
        if (transportMech != null && transportMech instanceof TSSSSLTransportConfig) {
            result.put("yoko.orb.policy.zero_port", "true");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("translateToProps(TSSConfig)");
            Enumeration<Object> iter = result.keys();
            while (iter.hasMoreElements()) {
                String key = (String)iter.nextElement();
                this.log.debug(key + " = " + result.getProperty(key));
            }
        }
        return result;
    }

    private String[] translateToArgs(CSSBean client) throws ConfigException {
        ArrayList<String> list = new ArrayList<String>();
        this.enableSocketFactory(client.getURI(), list);
        if (this.log.isDebugEnabled()) {
            for (String configArg : list) {
                this.log.debug(configArg);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private void enableSocketFactory(String uri, List<String> args) {
        args.add("-IIOPconnectionHelper");
        args.add("org.apache.geronimo.yoko.SocketFactory");
        args.add("-IIOPconnectionHelperArgs");
        args.add(uri);
    }

    private Properties translateToProps(CSSBean client) throws ConfigException {
        Properties result = new Properties();
        result.put("org.omg.CORBA.ORBClass", "org.apache.yoko.orb.CORBA.ORB");
        result.put("org.omg.CORBA.ORBSingletonClass", "org.apache.yoko.orb.CORBA.ORBSingleton");
        result.put("org.omg.PortableInterceptor.ORBInitializerClass.org.apache.geronimo.corba.transaction.TransactionInitializer", "");
        result.put("org.omg.PortableInterceptor.ORBInitializerClass.org.apache.geronimo.corba.security.SecurityInitializer", "");
        result.put("org.omg.PortableInterceptor.ORBInitializerClass.org.apache.geronimo.yoko.ORBInitializer", "");
        result.put("yoko.orb.id", client.getURI());
        if (this.log.isDebugEnabled()) {
            this.log.debug("translateToProps(CSSConfig)");
            Enumeration<Object> iter = result.keys();
            while (iter.hasMoreElements()) {
                String key = (String)iter.nextElement();
                this.log.debug(key + " = " + result.getProperty(key));
            }
        }
        return result;
    }

    private Properties translateToNameServiceProps(CSSBean client) throws ConfigException {
        Properties result = new Properties();
        result.put("org.omg.CORBA.ORBClass", "org.apache.yoko.orb.CORBA.ORB");
        result.put("org.omg.CORBA.ORBSingletonClass", "org.apache.yoko.orb.CORBA.ORBSingleton");
        if (this.log.isDebugEnabled()) {
            this.log.debug("translateToNameServiceProps(CSSConfig)");
            Enumeration<Object> iter = result.keys();
            while (iter.hasMoreElements()) {
                String key = (String)iter.nextElement();
                this.log.debug(key + " = " + result.getProperty(key));
            }
        }
        return result;
    }
}

