/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.yoko;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.corba.CORBABean;
import org.apache.geronimo.corba.CSSBean;
import org.apache.geronimo.corba.NameService;
import org.apache.geronimo.corba.ORBConfiguration;
import org.apache.geronimo.corba.security.config.ConfigAdapter;
import org.apache.geronimo.corba.security.config.ConfigException;
import org.apache.geronimo.corba.security.config.tss.TSSConfig;
import org.apache.geronimo.corba.security.config.tss.TSSSSLTransportConfig;
import org.apache.geronimo.corba.security.config.tss.TSSTransportMechConfig;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.yoko.orb.CosNaming.tnaming.TransientNameService;
import org.apache.yoko.orb.CosNaming.tnaming.TransientServiceException;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORBConfigAdapter
implements GBeanLifecycle,
ConfigAdapter {
    private final Log log = LogFactory.getLog(ORBConfigAdapter.class);

    public void doStart() throws Exception {
        System.setProperty("org.omg.CORBA.ORBClass", "org.apache.yoko.orb.CORBA.ORB");
        System.setProperty("org.omg.CORBA.ORBSingletonClass", "org.apache.yoko.orb.CORBA.ORBSingleton");
        System.setProperty("javax.rmi.CORBA.PortableRemoteObjectClass", "org.apache.yoko.rmi.impl.PortableRemoteObjectImpl");
        System.setProperty("javax.rmi.CORBA.StubClass", "org.apache.yoko.rmi.impl.StubImpl");
        System.setProperty("javax.rmi.CORBA.UtilClass", "org.apache.geronimo.corba.util.UtilDelegateImpl");
        System.setProperty("org.apache.geronimo.corba.UtilDelegateClass", "org.apache.yoko.rmi.impl.UtilImpl");
        System.setProperty("org.apache.yoko.rmi.RMIStubInitializerClass", "org.apache.geronimo.yoko.RMIStubHandlerFactory");
        Class<?> clazz = this.getClass().getClassLoader().loadClass("javax.rmi.PortableRemoteObject");
        Method m = clazz.getMethod("narrow", Object.class, Class.class);
        m.invoke(null, new Object(), Object.class);
        this.log.debug((Object)"Started  Yoko ORBConfigAdapter");
    }

    public void doStop() throws Exception {
        this.log.debug((Object)"Stopped Yoko ORBConfigAdapter");
    }

    public void doFail() {
        this.log.warn((Object)"Failed Yoko ORBConfigAdapter");
    }

    public ORB createServerORB(CORBABean server) throws ConfigException {
        ORB orb = this.createORB(server.getURI(), (ORBConfiguration)server, this.translateToArgs(server), this.translateToProps(server));
        TSSConfig config = server.getTssConfig();
        TSSTransportMechConfig transportMech = config.getTransport_mech();
        if (transportMech != null && transportMech instanceof TSSSSLTransportConfig) {
            Any any = orb.create_any();
            any.insert_boolean(true);
            try {
                Policy portPolicy = orb.create_policy(1330577419, any);
                Policy[] overrides = new Policy[]{portPolicy};
                server.setPolicyOverrides(overrides);
            }
            catch (PolicyError e) {
                // empty catch block
            }
        }
        return orb;
    }

    public ORB createClientORB(CSSBean client) throws ConfigException {
        return this.createORB(client.getURI(), (ORBConfiguration)client, this.translateToArgs(client), this.translateToProps(client));
    }

    public ORB createNameServiceClientORB(CSSBean client) throws ConfigException {
        return this.createORB(client.getURI(), (ORBConfiguration)client, this.translateToArgs(client), this.translateToNameServiceProps(client));
    }

    public Object createNameService(String host, int port) throws ConfigException {
        try {
            TransientNameService service = new TransientNameService(host, port, "NameService"){

                public void run() throws TransientServiceException {
                    Properties props = new Properties();
                    props.putAll((Map<?, ?>)System.getProperties());
                    props.put("org.omg.CORBA.ORBServerId", "1000000");
                    props.put("org.omg.CORBA.ORBClass", "org.apache.yoko.orb.CORBA.ORB");
                    props.put("org.omg.CORBA.ORBSingletonClass", "org.apache.yoko.orb.CORBA.ORBSingleton");
                    props.put("yoko.orb.oa.endpoint", "iiop --bind " + this.host + " --host " + this.host + " --port " + this.port);
                    this.createdOrb = ORB.init((String[])null, (Properties)props);
                    this.initialize(this.createdOrb);
                }
            };
            service.run();
            this.log.debug((Object)("Creating ORB endpoint with host=" + host + ", port=" + port));
            return service;
        }
        catch (TransientServiceException e) {
            throw new ConfigException("Error starting transient name service", (Throwable)e);
        }
    }

    public void destroyNameService(Object ns) {
        ((TransientNameService)ns).destroy();
    }

    private ORB createORB(String name, ORBConfiguration config, String[] args, Properties props) {
        return ORB.init((String[])args, (Properties)props);
    }

    private String[] translateToArgs(CORBABean server) throws ConfigException {
        ArrayList<String> list = new ArrayList<String>();
        this.enableSocketFactory(server.getURI(), list);
        NameService nameService = server.getNameService();
        if (nameService != null) {
            list.add("-ORBInitRef");
            list.add("NameService=" + nameService.getURI());
        }
        if (this.log.isDebugEnabled()) {
            for (String configArg : list) {
                this.log.debug((Object)configArg);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private Properties translateToProps(CORBABean server) throws ConfigException {
        Properties result = new Properties();
        result.put("org.omg.CORBA.ORBClass", "org.apache.yoko.orb.CORBA.ORB");
        result.put("org.omg.CORBA.ORBSingletonClass", "org.apache.yoko.orb.CORBA.ORBSingleton");
        result.put("org.omg.PortableInterceptor.ORBInitializerClass.org.apache.geronimo.corba.transaction.TransactionInitializer", "");
        result.put("org.omg.PortableInterceptor.ORBInitializerClass.org.apache.geronimo.corba.security.SecurityInitializer", "");
        result.put("org.omg.PortableInterceptor.ORBInitializerClass.org.apache.geronimo.yoko.ORBInitializer", "");
        if (server.getPort() > 0) {
            result.put("yoko.orb.oa.endpoint", "iiop --bind " + server.getHost() + " --host " + server.getHost() + " --port " + server.getPort());
        } else {
            result.put("yoko.orb.oa.endpoint", "iiop --bind " + server.getHost() + " --host " + server.getHost());
        }
        result.put("yoko.orb.id", server.getURI());
        TSSConfig config = server.getTssConfig();
        TSSTransportMechConfig transportMech = config.getTransport_mech();
        if (transportMech != null && transportMech instanceof TSSSSLTransportConfig) {
            result.put("yoko.orb.policy.zero_port", "true");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"translateToProps(TSSConfig)");
            Enumeration<Object> iter = result.keys();
            while (iter.hasMoreElements()) {
                String key = (String)iter.nextElement();
                this.log.debug((Object)(key + " = " + result.getProperty(key)));
            }
        }
        return result;
    }

    private String[] translateToArgs(CSSBean client) throws ConfigException {
        ArrayList<String> list = new ArrayList<String>();
        this.enableSocketFactory(client.getURI(), list);
        if (this.log.isDebugEnabled()) {
            for (String configArg : list) {
                this.log.debug((Object)configArg);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private void enableSocketFactory(String uri, List<String> args) {
        args.add("-IIOPconnectionHelper");
        args.add("org.apache.geronimo.yoko.SocketFactory");
        args.add("-IIOPconnectionHelperArgs");
        args.add(uri);
    }

    private Properties translateToProps(CSSBean client) throws ConfigException {
        Properties result = new Properties();
        result.put("org.omg.CORBA.ORBClass", "org.apache.yoko.orb.CORBA.ORB");
        result.put("org.omg.CORBA.ORBSingletonClass", "org.apache.yoko.orb.CORBA.ORBSingleton");
        result.put("org.omg.PortableInterceptor.ORBInitializerClass.org.apache.geronimo.corba.transaction.TransactionInitializer", "");
        result.put("org.omg.PortableInterceptor.ORBInitializerClass.org.apache.geronimo.corba.security.SecurityInitializer", "");
        result.put("org.omg.PortableInterceptor.ORBInitializerClass.org.apache.geronimo.yoko.ORBInitializer", "");
        result.put("yoko.orb.id", client.getURI());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"translateToProps(CSSConfig)");
            Enumeration<Object> iter = result.keys();
            while (iter.hasMoreElements()) {
                String key = (String)iter.nextElement();
                this.log.debug((Object)(key + " = " + result.getProperty(key)));
            }
        }
        return result;
    }

    private Properties translateToNameServiceProps(CSSBean client) throws ConfigException {
        Properties result = new Properties();
        result.put("org.omg.CORBA.ORBClass", "org.apache.yoko.orb.CORBA.ORB");
        result.put("org.omg.CORBA.ORBSingletonClass", "org.apache.yoko.orb.CORBA.ORBSingleton");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"translateToNameServiceProps(CSSConfig)");
            Enumeration<Object> iter = result.keys();
            while (iter.hasMoreElements()) {
                String key = (String)iter.nextElement();
                this.log.debug((Object)(key + " = " + result.getProperty(key)));
            }
        }
        return result;
    }
}

