/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.webservices.jaxr;

import javax.xml.registry.ConnectionFactory;
import javax.xml.registry.JAXRException;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.OsgiService;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.naming.ResourceSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean(j2eeType="JAXRConnectionFactory")
@OsgiService
public class JAXRGBean
implements ResourceSource {
    private static final Logger log = LoggerFactory.getLogger(JAXRGBean.class);
    private final ClassLoader cl;
    private final String connectionFactoryClass;

    public JAXRGBean(@ParamAttribute(name="connectionFactoryClass") String connectionFactoryClass, @ParamSpecial(type=SpecialAttributeType.classLoader) ClassLoader cl) {
        this.cl = cl;
        this.connectionFactoryClass = connectionFactoryClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object $getResource() {
        if (this.connectionFactoryClass != null) {
            System.setProperty("javax.xml.registry.ConnectionFactoryClass", this.connectionFactoryClass);
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader oldCl = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this.cl);
        try {
            ConnectionFactory connectionFactory = ConnectionFactory.newInstance();
            return connectionFactory;
        }
        catch (JAXRException e) {
            log.error("Error creating ConnectionFactory", (Throwable)e);
        }
        finally {
            currentThread.setContextClassLoader(oldCl);
        }
        return null;
    }
}

