/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.webservices;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.geronimo.webservices.WebServiceContainer;

public class WebServiceContainerInvoker
implements Servlet {
    public static final String WEBSERVICE_CONTAINER = WebServiceContainerInvoker.class.getName() + "@WebServiceContainer";
    private final Object pojo;
    private WebServiceContainer service;
    private ServletConfig config;

    public WebServiceContainerInvoker(Object pojo) {
        this.pojo = pojo;
    }

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
        ServletContext context = config.getServletContext();
        String webServiceContainerID = config.getInitParameter(WEBSERVICE_CONTAINER);
        this.service = (WebServiceContainer)context.getAttribute(webServiceContainerID);
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        res.setContentType("text/xml");
        RequestAdapter request = new RequestAdapter((HttpServletRequest)req);
        ResponseAdapter response = new ResponseAdapter((HttpServletResponse)res);
        req.setAttribute(WebServiceContainer.POJO_INSTANCE, this.pojo);
        req.setAttribute(WebServiceContainer.SERVLET_REQUEST, (Object)req);
        req.setAttribute(WebServiceContainer.SERVLET_RESPONSE, (Object)res);
        req.setAttribute(WebServiceContainer.SERVLET_CONTEXT, (Object)this.config.getServletContext());
        if (req.getParameter("wsdl") != null || req.getParameter("WSDL") != null) {
            try {
                this.service.getWsdl(request, response);
            }
            catch (IOException e) {
                throw e;
            }
            catch (ServletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException("Could not fetch wsdl!", (Throwable)e);
            }
        }
        try {
            this.service.invoke(request, response);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException("Could not process message!", (Throwable)e);
        }
    }

    public String getServletInfo() {
        return null;
    }

    public void destroy() {
        this.service.destroy();
    }

    private static class ResponseAdapter
    implements WebServiceContainer.Response {
        private final HttpServletResponse response;

        public ResponseAdapter(HttpServletResponse response) {
            this.response = response;
        }

        @Override
        public void setHeader(String name, String value) {
            this.response.setHeader(name, value);
        }

        @Override
        public String getHeader(String name) {
            throw new UnsupportedOperationException("Not possible to implement");
        }

        @Override
        public OutputStream getOutputStream() {
            try {
                return this.response.getOutputStream();
            }
            catch (IOException e) {
                throw (IllegalStateException)new IllegalStateException().initCause(e);
            }
        }

        @Override
        public void setStatusCode(int code) {
            this.response.setStatus(code);
        }

        @Override
        public int getStatusCode() {
            throw new UnsupportedOperationException("Not possible to implement");
        }

        @Override
        public void setContentType(String type) {
            this.response.setContentType(type);
        }

        @Override
        public String getContentType() {
            return this.response.getContentType();
        }

        @Override
        public void setStatusMessage(String responseString) {
            this.response.setStatus(this.getStatusCode(), responseString);
        }

        @Override
        public void flushBuffer() throws IOException {
            this.response.flushBuffer();
        }
    }

    private static class RequestAdapter
    implements WebServiceContainer.Request {
        private final HttpServletRequest request;
        private static final Map<String, Integer> methods = new HashMap<String, Integer>();

        public RequestAdapter(HttpServletRequest request) {
            this.request = request;
        }

        @Override
        public String getHeader(String name) {
            return this.request.getHeader(name);
        }

        @Override
        public URI getURI() {
            try {
                return new URI(this.request.getScheme(), null, this.request.getServerName(), this.request.getServerPort(), this.request.getRequestURI(), this.request.getQueryString(), null);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }

        @Override
        public int getContentLength() {
            return this.request.getContentLength();
        }

        @Override
        public String getContentType() {
            return this.request.getContentType();
        }

        @Override
        public String getContextPath() {
            return this.request.getContextPath();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.request.getInputStream();
        }

        @Override
        public int getMethod() {
            Integer method = methods.get(this.request.getMethod());
            return method == null ? 8 : method;
        }

        @Override
        public String getParameter(String name) {
            return this.request.getParameter(name);
        }

        @Override
        public Map<String, String[]> getParameters() {
            return this.request.getParameterMap();
        }

        @Override
        public Object getAttribute(String s) {
            return this.request.getAttribute(s);
        }

        @Override
        public void setAttribute(String s, Object o) {
            this.request.setAttribute(s, o);
        }

        @Override
        public String getRemoteAddr() {
            return this.request.getRemoteAddr();
        }

        static {
            methods.put("OPTIONS", 0);
            methods.put("GET", 1);
            methods.put("HEAD", 2);
            methods.put("POST", 3);
            methods.put("PUT", 4);
            methods.put("DELETE", 5);
            methods.put("TRACE", 6);
            methods.put("CONNECT", 7);
        }
    }
}

