/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.webservices;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.server.ServiceLifecycle;
import javax.xml.rpc.server.ServletEndpointContext;
import org.apache.geronimo.webservices.WebServiceContainer;

public class ServiceLifecycleManager
implements Servlet {
    private final ServiceLifecycle managedService;
    private final Servlet next;
    private static final DefaultContext DEFAULT_CONTEXT = new DefaultContext();
    private static final ThreadLocal endpointContext = new ThreadLocal();

    public ServiceLifecycleManager(Servlet next, ServiceLifecycle managedService) {
        this.next = next;
        this.managedService = managedService;
    }

    public void init(ServletConfig config) throws ServletException {
        this.next.init(config);
        try {
            this.managedService.init((Object)new InstanceContext(config.getServletContext()));
        }
        catch (ServiceException e) {
            throw new ServletException("Unable to initialize ServiceEndpoint", (Throwable)e);
        }
    }

    public ServletConfig getServletConfig() {
        return this.next.getServletConfig();
    }

    public String getServletInfo() {
        return this.next.getServletInfo();
    }

    public void destroy() {
        this.managedService.destroy();
        this.next.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        ServletEndpointContext context = ServiceLifecycleManager.getContext();
        try {
            endpointContext.set(new InvocationContext((HttpServletRequest)req));
            this.next.service(req, res);
        }
        finally {
            endpointContext.set(context);
        }
    }

    private static ServletEndpointContext getContext() {
        ServletEndpointContext context = (ServletEndpointContext)endpointContext.get();
        return context != null ? context : DEFAULT_CONTEXT;
    }

    static class DefaultContext
    implements ServletEndpointContext {
        DefaultContext() {
        }

        public MessageContext getMessageContext() {
            throw new IllegalStateException("Method cannot be called outside a request context");
        }

        public Principal getUserPrincipal() {
            throw new IllegalStateException("Method cannot be called outside a request context");
        }

        public HttpSession getHttpSession() {
            throw new JAXRPCException("Method cannot be called outside an http request context");
        }

        public ServletContext getServletContext() {
            throw new IllegalAccessError("InstanceContext should never delegate this method.");
        }

        public boolean isUserInRole(String s) {
            throw new IllegalStateException("Method cannot be called outside a request context");
        }
    }

    static class InvocationContext
    implements ServletEndpointContext {
        private final HttpServletRequest request;

        public InvocationContext(HttpServletRequest request) {
            this.request = request;
        }

        public MessageContext getMessageContext() {
            return (MessageContext)this.request.getAttribute(WebServiceContainer.MESSAGE_CONTEXT);
        }

        public Principal getUserPrincipal() {
            return this.request.getUserPrincipal();
        }

        public HttpSession getHttpSession() {
            return this.request.getSession();
        }

        public ServletContext getServletContext() {
            throw new IllegalAccessError("InstanceContext should never delegate this method.");
        }

        public boolean isUserInRole(String s) {
            return this.request.isUserInRole(s);
        }
    }

    static class InstanceContext
    implements ServletEndpointContext {
        private final ServletContext servletContext;

        public InstanceContext(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        public MessageContext getMessageContext() {
            return ServiceLifecycleManager.getContext().getMessageContext();
        }

        public Principal getUserPrincipal() {
            return ServiceLifecycleManager.getContext().getUserPrincipal();
        }

        public HttpSession getHttpSession() {
            return ServiceLifecycleManager.getContext().getHttpSession();
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }

        public boolean isUserInRole(String s) {
            return ServiceLifecycleManager.getContext().isUserInRole(s);
        }
    }
}

