/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.webservices.jaxr;

import javax.xml.registry.ConnectionFactory;
import javax.xml.registry.JAXRException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;

public class JAXRGBean {
    private final Log log = LogFactory.getLog(JAXRGBean.class);
    private final ClassLoader cl;
    private final String connectionFactoryClass;
    public static final GBeanInfo GBEAN_INFO;

    public JAXRGBean(String connectionFactoryClass, ClassLoader cl) {
        this.cl = cl;
        this.connectionFactoryClass = connectionFactoryClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object $getResource() {
        if (this.connectionFactoryClass != null) {
            System.setProperty("javax.xml.registry.ConnectionFactoryClass", this.connectionFactoryClass);
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader oldCl = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this.cl);
        try {
            ConnectionFactory connectionFactory = ConnectionFactory.newInstance();
            return connectionFactory;
        }
        catch (JAXRException e) {
            this.log.error((Object)"Error creating ConnectionFactory", (Throwable)e);
        }
        finally {
            currentThread.setContextClassLoader(oldCl);
        }
        return null;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(JAXRGBean.class, (String)"JAXRConnectionFactory");
        infoFactory.addAttribute("connectionFactoryClass", String.class, true, true);
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.addOperation("$getResource");
        infoFactory.setConstructor(new String[]{"connectionFactoryClass", "classLoader"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

