/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.webservices.builder;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.holders.BigDecimalHolder;
import javax.xml.rpc.holders.BigIntegerHolder;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.BooleanWrapperHolder;
import javax.xml.rpc.holders.ByteArrayHolder;
import javax.xml.rpc.holders.ByteHolder;
import javax.xml.rpc.holders.ByteWrapperHolder;
import javax.xml.rpc.holders.CalendarHolder;
import javax.xml.rpc.holders.DoubleHolder;
import javax.xml.rpc.holders.DoubleWrapperHolder;
import javax.xml.rpc.holders.FloatHolder;
import javax.xml.rpc.holders.FloatWrapperHolder;
import javax.xml.rpc.holders.IntHolder;
import javax.xml.rpc.holders.IntegerWrapperHolder;
import javax.xml.rpc.holders.LongHolder;
import javax.xml.rpc.holders.LongWrapperHolder;
import javax.xml.rpc.holders.ObjectHolder;
import javax.xml.rpc.holders.QNameHolder;
import javax.xml.rpc.holders.ShortHolder;
import javax.xml.rpc.holders.ShortWrapperHolder;
import javax.xml.rpc.holders.StringHolder;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.kernel.ClassLoading;
import org.apache.geronimo.webservices.builder.DescriptorVersion;
import org.apache.geronimo.webservices.builder.PortInfo;
import org.apache.geronimo.webservices.builder.SharedPortInfo;
import org.apache.openejb.jee.ExceptionMapping;
import org.apache.openejb.jee.Handler;
import org.apache.openejb.jee.JavaWsdlMapping;
import org.apache.openejb.jee.JaxbJavaee;
import org.apache.openejb.jee.PackageMapping;
import org.apache.openejb.jee.ParamValue;
import org.apache.openejb.jee.PortComponent;
import org.apache.openejb.jee.ServiceEndpointInterfaceMapping;
import org.apache.openejb.jee.ServiceEndpointMethodMapping;
import org.apache.openejb.jee.ServiceImplBean;
import org.apache.openejb.jee.WebserviceDescription;
import org.apache.openejb.jee.Webservices;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSDescriptorParser {
    private static final Logger logger = LoggerFactory.getLogger(WSDescriptorParser.class);
    private static final Map<Class, Class> rpcHolderClasses = new HashMap<Class, Class>();

    public static JavaWsdlMapping readJaxrpcMapping(JarFile moduleFile, URI jaxrpcMappingURI) throws DeploymentException {
        String jaxrpcMappingPath = jaxrpcMappingURI.toString();
        return WSDescriptorParser.readJaxrpcMapping(moduleFile, jaxrpcMappingPath);
    }

    public static JavaWsdlMapping readJaxrpcMapping(JarFile moduleFile, String jaxrpcMappingPath) throws DeploymentException {
        InputStream jaxrpcInputStream;
        try {
            ZipEntry zipEntry = moduleFile.getEntry(jaxrpcMappingPath);
            if (zipEntry == null) {
                throw new DeploymentException("The JAX-RPC mapping file " + jaxrpcMappingPath + " specified in webservices.xml could not be found.");
            }
            jaxrpcInputStream = moduleFile.getInputStream(zipEntry);
        }
        catch (IOException e) {
            throw new DeploymentException("Could not open stream to jaxrpc mapping document", (Throwable)e);
        }
        try {
            JavaWsdlMapping e = (JavaWsdlMapping)JaxbJavaee.unmarshalJavaee(JavaWsdlMapping.class, (InputStream)jaxrpcInputStream);
            return e;
        }
        catch (Exception e) {
            throw new DeploymentException("Could not parse jaxrpc mapping document", (Throwable)e);
        }
        finally {
            try {
                jaxrpcInputStream.close();
            }
            catch (IOException e) {}
        }
    }

    public static Map<QName, ExceptionMapping> getExceptionMap(JavaWsdlMapping mapping) {
        HashMap<QName, ExceptionMapping> exceptionMap = new HashMap<QName, ExceptionMapping>();
        if (mapping != null) {
            Collection exceptionMappings = mapping.getExceptionMapping();
            for (ExceptionMapping exceptionMapping : exceptionMappings) {
                QName exceptionMessageQName = exceptionMapping.getWsdlMessage();
                exceptionMap.put(exceptionMessageQName, exceptionMapping);
            }
        }
        return exceptionMap;
    }

    public static String getPackageFromNamespace(String namespace, JavaWsdlMapping mapping) throws DeploymentException {
        Collection packageMappings = mapping.getPackageMapping();
        for (PackageMapping packageMapping : packageMappings) {
            if (!namespace.equals(packageMapping.getNamespaceURI().trim())) continue;
            return packageMapping.getPackageType().trim();
        }
        throw new DeploymentException("Namespace " + namespace + " was not mapped in jaxrpc mapping file");
    }

    public static Class getHolder(String paramJavaTypeName, boolean isInOnly, QName typeQName, boolean isComplexType, JavaWsdlMapping mapping, Bundle bundle) throws DeploymentException {
        String holderName;
        if (isInOnly) {
            Class paramJavaType;
            try {
                paramJavaType = ClassLoading.loadClass((String)paramJavaTypeName, (Bundle)bundle);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("could not load parameter type", (Throwable)e);
            }
            return paramJavaType;
        }
        if (isComplexType) {
            String namespace = typeQName.getNamespaceURI();
            String packageName = WSDescriptorParser.getPackageFromNamespace(namespace, mapping);
            StringBuilder buf = new StringBuilder(packageName.length() + typeQName.getLocalPart().length() + 14);
            buf.append(packageName).append(".holders.").append(typeQName.getLocalPart()).append("Holder");
            buf.setCharAt(packageName.length() + 9, Character.toUpperCase(typeQName.getLocalPart().charAt(0)));
            holderName = buf.toString();
        } else {
            Class paramJavaType;
            try {
                paramJavaType = ClassLoading.loadClass((String)paramJavaTypeName, (Bundle)bundle);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("could not load parameter type", (Throwable)e);
            }
            Class holder = rpcHolderClasses.get(paramJavaType);
            if (holder != null) {
                try {
                    holder = ClassLoading.loadClass((String)holder.getName(), (Bundle)bundle);
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentException("could not load holder type in correct classloader", (Throwable)e);
                }
                return holder;
            }
            String paramTypeName = paramJavaType.getName();
            StringBuilder buf = new StringBuilder(paramTypeName.length() + 14);
            int dot = paramTypeName.lastIndexOf(".");
            buf.append(paramTypeName.substring(0, dot)).append(".holders").append(paramTypeName.substring(dot)).append("Holder");
            holderName = buf.toString();
        }
        try {
            return ClassLoading.loadClass((String)holderName, (Bundle)bundle);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Could not load holder class", (Throwable)e);
        }
    }

    public static ServiceEndpointMethodMapping getMethodMappingForOperation(String operationName, List<ServiceEndpointMethodMapping> methodMappings) throws DeploymentException {
        for (ServiceEndpointMethodMapping methodMapping : methodMappings) {
            if (!operationName.equals(methodMapping.getWsdlOperation())) continue;
            return methodMapping;
        }
        StringBuilder availOps = new StringBuilder(128);
        for (ServiceEndpointMethodMapping mapping : methodMappings) {
            if (availOps.length() > 0) {
                availOps.append(",");
            }
            availOps.append(mapping.getWsdlOperation());
        }
        throw new DeploymentException("No method found for operation named '" + operationName + "'. Available operations: " + availOps);
    }

    public static ServiceEndpointInterfaceMapping getServiceEndpointInterfaceMapping(List<ServiceEndpointInterfaceMapping> endpointMappings, QName portTypeQName) throws DeploymentException {
        for (ServiceEndpointInterfaceMapping endpointMapping : endpointMappings) {
            QName testPortQName = endpointMapping.getWsdlPortType();
            if (!portTypeQName.equals(testPortQName)) continue;
            return endpointMapping;
        }
        throw new DeploymentException("Could not find service endpoint interface for port named " + portTypeQName);
    }

    public static Service getService(QName serviceQName, Definition definition) throws DeploymentException {
        Service service;
        if (serviceQName != null) {
            service = definition.getService(serviceQName);
        } else {
            Map services = definition.getServices();
            if (services.size() != 1) {
                throw new DeploymentException("no serviceQName supplied, and there are " + services.size() + " services");
            }
            service = (Service)services.values().iterator().next();
        }
        if (service == null) {
            throw new DeploymentException("No service wsdl for supplied service qname " + serviceQName);
        }
        return service;
    }

    public static Method getMethodForOperation(Class serviceEndpointInterface, Operation operation) throws DeploymentException {
        Method[] methods = serviceEndpointInterface.getMethods();
        String opName = operation.getName();
        Method found = null;
        for (Method method : methods) {
            if (!method.getName().equals(opName)) continue;
            if (found != null) {
                throw new DeploymentException("Overloaded methods are not allowed in lightweight mappings");
            }
            found = method;
        }
        if (found == null) {
            throw new DeploymentException("No method found for operation named " + opName);
        }
        return found;
    }

    public static Map<String, PortInfo> parseWebServiceDescriptor(Webservices webservices, JarFile moduleFile, boolean isEJB, Map servletLocations) throws DeploymentException {
        HashMap<String, PortInfo> portMap = new HashMap<String, PortInfo>();
        Collection webserviceDescriptions = webservices.getWebserviceDescription();
        for (WebserviceDescription webserviceDescription : webserviceDescriptions) {
            if (webserviceDescription.getWsdlFile() == null || webserviceDescription.getJaxrpcMappingFile() == null) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("This entry " + webserviceDescription.getDescription() + "should be a JAX-WS configuration, it will be ignored by JAX-RPC builder");
                continue;
            }
            String wsdlLocation = webserviceDescription.getWsdlFile().trim();
            String jaxrpcMappingFile = webserviceDescription.getJaxrpcMappingFile().trim();
            SharedPortInfo sharedPortInfo = new SharedPortInfo(wsdlLocation, jaxrpcMappingFile, DescriptorVersion.J2EE);
            Collection portComponents = webserviceDescription.getPortComponent();
            for (PortComponent portComponent : portComponents) {
                PortInfo portInfo;
                String servletLocation;
                String linkName;
                String portComponentName = portComponent.getPortComponentName().trim();
                QName portQName = portComponent.getWsdlPort();
                String seiInterfaceName = portComponent.getServiceEndpointInterface().trim();
                ServiceImplBean serviceImplBean = portComponent.getServiceImplBean();
                if (isEJB == (serviceImplBean.getServletLink() != null)) {
                    throw new DeploymentException("Wrong kind of web service described in web service descriptor: expected " + (isEJB ? "EJB" : "POJO(Servlet)"));
                }
                if (serviceImplBean.getServletLink() != null) {
                    linkName = serviceImplBean.getServletLink().trim();
                    servletLocation = (String)servletLocations.get(linkName);
                    if (servletLocation == null) {
                        throw new DeploymentException("No servlet mapping for port " + portComponentName);
                    }
                } else {
                    linkName = serviceImplBean.getEjbLink().trim();
                    servletLocation = (String)servletLocations.get(linkName);
                }
                if (portMap.put(linkName, portInfo = new PortInfo(sharedPortInfo, portComponentName, portQName, seiInterfaceName, portComponent.getHandlerChains(), servletLocation)) == null) continue;
                throw new DeploymentException("Ambiguous description of port associated with j2ee component " + linkName);
            }
        }
        return portMap;
    }

    public static Map<String, PortInfo> parseWebServiceDescriptor2(Webservices webservices, JarFile moduleFile, boolean isEJB, Map servletLocations) throws DeploymentException {
        HashMap<String, PortInfo> portMap = new HashMap<String, PortInfo>();
        Collection webserviceDescriptions = webservices.getWebserviceDescription();
        for (WebserviceDescription webserviceDescription : webserviceDescriptions) {
            String wsdlLocation = null;
            if (webserviceDescription.getWsdlFile() != null) {
                wsdlLocation = webserviceDescription.getWsdlFile().trim();
            }
            String jaxrpcMappingFile = null;
            if (webserviceDescription.getJaxrpcMappingFile() != null) {
                jaxrpcMappingFile = webserviceDescription.getJaxrpcMappingFile().trim();
            }
            SharedPortInfo sharedPortInfo = new SharedPortInfo(wsdlLocation, jaxrpcMappingFile, DescriptorVersion.JAVAEE);
            Collection portComponents = webserviceDescription.getPortComponent();
            for (PortComponent portComponent : portComponents) {
                String servletLocation;
                String linkName;
                ServiceImplBean serviceImplBean;
                String portComponentName = portComponent.getPortComponentName().trim();
                QName portQName = null;
                if (portComponent.getWsdlPort() != null) {
                    portQName = portComponent.getWsdlPort();
                }
                String seiInterfaceName = null;
                if (portComponent.getServiceEndpointInterface() != null) {
                    seiInterfaceName = portComponent.getServiceEndpointInterface().trim();
                }
                if (isEJB == ((serviceImplBean = portComponent.getServiceImplBean()).getServletLink() != null)) {
                    throw new DeploymentException("Wrong kind of web service described in web service descriptor: expected " + (isEJB ? "EJB" : "POJO(Servlet)"));
                }
                if (serviceImplBean.getServletLink() != null) {
                    linkName = serviceImplBean.getServletLink().trim();
                    servletLocation = (String)servletLocations.get(linkName);
                    if (servletLocation != null) continue;
                    throw new DeploymentException("No servlet mapping for port " + portComponentName);
                }
                linkName = serviceImplBean.getEjbLink().trim();
                servletLocation = (String)servletLocations.get(linkName);
            }
        }
        return portMap;
    }

    public static Map<String, PortInfo> parseWebServiceDescriptor(URL wsDDUrl, JarFile moduleFile, boolean isEJB, Map servletLocations) throws DeploymentException {
        Webservices webservices = WSDescriptorParser.getWebservices(wsDDUrl);
        if (webservices instanceof Webservices) {
            Webservices webServices = webservices;
            return WSDescriptorParser.parseWebServiceDescriptor(webServices, moduleFile, isEJB, servletLocations);
        }
        return null;
    }

    static Webservices getWebservices(URL wsDDUrl) throws DeploymentException {
        Webservices webservices;
        InputStream in = wsDDUrl.openStream();
        try {
            webservices = (Webservices)JaxbJavaee.unmarshalJavaee(Webservices.class, (InputStream)in);
        }
        catch (Exception e) {
            try {
                try {
                    throw new DeploymentException("Could not read descriptor document", (Throwable)e);
                }
                catch (Throwable throwable) {
                    in.close();
                    throw throwable;
                }
            }
            catch (IOException e2) {
                return null;
            }
        }
        in.close();
        return webservices;
    }

    public static List<HandlerInfo> createHandlerInfoList(List<Handler> handlers, Bundle bundle) throws DeploymentException {
        ArrayList<HandlerInfo> list = new ArrayList<HandlerInfo>();
        for (Handler handler : handlers) {
            Class handlerClass;
            String className = handler.getHandlerClass().trim();
            try {
                handlerClass = bundle.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Unable to load handler class: " + className, (Throwable)e);
            }
            HashMap<String, String> config = new HashMap<String, String>();
            List paramValues = handler.getInitParam();
            for (ParamValue paramValue : paramValues) {
                String paramName = paramValue.getParamName().trim();
                String paramStringValue = paramValue.getParamValue().trim();
                config.put(paramName, paramStringValue);
            }
            List soapHeaderQNames = handler.getSoapHeader();
            QName[] headers = soapHeaderQNames.toArray(new QName[soapHeaderQNames.size()]);
            list.add(new HandlerInfo(handlerClass, config, headers));
        }
        return list;
    }

    static {
        rpcHolderClasses.put(BigDecimal.class, BigDecimalHolder.class);
        rpcHolderClasses.put(BigInteger.class, BigIntegerHolder.class);
        rpcHolderClasses.put(Boolean.TYPE, BooleanHolder.class);
        rpcHolderClasses.put(Boolean.class, BooleanWrapperHolder.class);
        rpcHolderClasses.put(byte[].class, ByteArrayHolder.class);
        rpcHolderClasses.put(Byte.TYPE, ByteHolder.class);
        rpcHolderClasses.put(Byte.class, ByteWrapperHolder.class);
        rpcHolderClasses.put(Calendar.class, CalendarHolder.class);
        rpcHolderClasses.put(Double.TYPE, DoubleHolder.class);
        rpcHolderClasses.put(Double.class, DoubleWrapperHolder.class);
        rpcHolderClasses.put(Float.TYPE, FloatHolder.class);
        rpcHolderClasses.put(Float.class, FloatWrapperHolder.class);
        rpcHolderClasses.put(Integer.TYPE, IntHolder.class);
        rpcHolderClasses.put(Integer.class, IntegerWrapperHolder.class);
        rpcHolderClasses.put(Long.TYPE, LongHolder.class);
        rpcHolderClasses.put(Long.class, LongWrapperHolder.class);
        rpcHolderClasses.put(Object.class, ObjectHolder.class);
        rpcHolderClasses.put(QName.class, QNameHolder.class);
        rpcHolderClasses.put(Short.TYPE, ShortHolder.class);
        rpcHolderClasses.put(Short.class, ShortWrapperHolder.class);
        rpcHolderClasses.put(String.class, StringHolder.class);
    }
}

