/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.webservices.builder;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.jar.JarFile;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.webservices.builder.DescriptorVersion;
import org.apache.geronimo.webservices.builder.SchemaInfoBuilder;
import org.apache.geronimo.webservices.builder.SharedPortInfo;
import org.apache.geronimo.xbeans.j2ee.JavaWsdlMappingType;
import org.apache.geronimo.xbeans.j2ee.PortComponentHandlerType;
import org.apache.geronimo.xbeans.j2ee.ServiceEndpointInterfaceMappingType;

public class PortInfo {
    private final String portComponentName;
    private final QName portQName;
    private final String seInterfaceName;
    private final PortComponentHandlerType[] handlers;
    private final SharedPortInfo sharedPortInfo;
    private SchemaInfoBuilder schemaInfoBuilder;
    private JavaWsdlMappingType javaWsdlMapping;
    private Port port;
    private ServiceEndpointInterfaceMappingType seiMapping;
    private URI contextURI;
    private String location;

    public PortInfo(SharedPortInfo sharedPortInfo, String portComponentName, QName portQName, String seiInterfaceName, PortComponentHandlerType[] handlers, String location) {
        this.sharedPortInfo = sharedPortInfo;
        this.portComponentName = portComponentName;
        this.portQName = portQName;
        this.seInterfaceName = seiInterfaceName;
        this.handlers = handlers;
        this.location = location;
    }

    public DescriptorVersion getDescriptorVersion() {
        return this.sharedPortInfo.getDescriptorVersion();
    }

    public String getWsdlLocation() {
        return this.sharedPortInfo.getWsdlLocation();
    }

    public String getPortComponentName() {
        return this.portComponentName;
    }

    public QName getPortQName() {
        return this.portQName;
    }

    public Port getPort() {
        return this.port;
    }

    public SchemaInfoBuilder getSchemaInfoBuilder() {
        return this.schemaInfoBuilder;
    }

    public Definition getDefinition() {
        return this.schemaInfoBuilder.getDefinition();
    }

    public JavaWsdlMappingType getJavaWsdlMapping() {
        return this.javaWsdlMapping;
    }

    public String getServiceEndpointInterfaceName() {
        return this.seInterfaceName;
    }

    public ServiceEndpointInterfaceMappingType getServiceEndpointInterfaceMapping() {
        return this.seiMapping;
    }

    public PortComponentHandlerType[] getHandlers() {
        return this.handlers;
    }

    public URI getContextURI() {
        return this.contextURI;
    }

    public void initialize(JarFile moduleFile) throws DeploymentException {
        this.sharedPortInfo.initialize(moduleFile);
        this.schemaInfoBuilder = this.sharedPortInfo.getSchemaInfoBuilder();
        this.javaWsdlMapping = this.sharedPortInfo.getJavaWsdlMapping();
        QName portQName = this.getPortQName();
        String portComponentName = this.getPortComponentName();
        String seiInterfaceName = this.getServiceEndpointInterfaceName();
        Map wsdlPortMap = this.schemaInfoBuilder.getPortMap();
        Port wsdlPort = (Port)wsdlPortMap.get(portQName.getLocalPart());
        if (wsdlPort == null) {
            throw new DeploymentException("No WSDL Port definition for port-component " + portComponentName);
        }
        this.port = wsdlPort;
        this.seiMapping = this.sharedPortInfo.getSEIMappings().get(seiInterfaceName);
        this.location = this.schemaInfoBuilder.movePortLocation(portQName.getLocalPart(), this.location);
        try {
            this.contextURI = new URI(this.location);
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Could not construct URI for web service location", (Throwable)e);
        }
    }
}

